/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.ZyGraph.Implementations;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Searchers.Text.Model.SearchResult;
import com.google.security.zynamics.binnavi.ZyGraph.ZyGraphViewSettings;
import com.google.security.zynamics.binnavi.yfileswrap.Gui.GraphWindows.Searchers.Text.Model.GraphSearcher;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviEdge;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.GraphHelpers;
import com.google.security.zynamics.zylib.gui.zygraph.proximity.ProximityRangeCalculator;
import com.google.security.zynamics.zylib.types.common.CollectionHelpers;
import com.google.security.zynamics.zylib.types.common.ICollectionFilter;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JFrame;

public final class CGraphFunctions {
    private CGraphFunctions() {
    }

    private static int countInvisibleNodes(Collection<NaviNode> nodes) {
        return CollectionHelpers.countIf(nodes, new ICollectionFilter<NaviNode>(){

            @Override
            public boolean qualifies(NaviNode item) {
                return !item.isVisible();
            }
        });
    }

    private static boolean userCancelsMakingVisible(Window parent, ZyGraph graph, int invisibleNodes) {
        return invisibleNodes >= graph.getSettings().getLayoutSettings().getVisibilityWarningTreshold() && 0 != CMessageBox.showYesNoCancelQuestion(parent, String.format("The selected operation makes %d more nodes visible. Do you want to continue?", invisibleNodes));
    }

    public static void selectNodesWithString(ZyGraph graph, String searchString) {
        Preconditions.checkNotNull(graph, "IE02117: Graph argument can not be null");
        Preconditions.checkNotNull(searchString, "IE02118: Search string argument can not be null");
        GraphSearcher searcher = new GraphSearcher();
        searcher.search(GraphHelpers.getNodes(graph), new ArrayList<NaviEdge>(), searchString);
        List<SearchResult> results = searcher.getResults();
        ArrayList<NaviNode> resultNodes = new ArrayList<NaviNode>();
        for (SearchResult searchResult : results) {
            resultNodes.add((NaviNode)searchResult.getObject());
        }
        graph.selectNodes(resultNodes, true);
        searcher.dispose();
    }

    public static void showNodes(JFrame parent, ZyGraph graph, Collection<NaviNode> toShow, Collection<NaviNode> toHide) {
        Preconditions.checkNotNull(graph, "IE02120: Graph argument can not be null");
        Preconditions.checkNotNull(toShow, "IE02121: toShow argument can not be null");
        Preconditions.checkNotNull(toHide, "IE02122: toHide argument can not be null");
        ZyGraphViewSettings settings = graph.getSettings();
        Set<NaviNode> neighbours = ProximityRangeCalculator.getNeighbors(graph, toShow, settings.getProximitySettings().getProximityBrowsingChildren(), settings.getProximitySettings().getProximityBrowsingParents());
        neighbours.addAll(toShow);
        int invisibleNodes = CGraphFunctions.countInvisibleNodes(neighbours);
        if (CGraphFunctions.userCancelsMakingVisible(parent, graph, invisibleNodes)) {
            return;
        }
        graph.showNodes(toShow, toHide);
    }

    public static void showNodes(Window parent, ZyGraph graph, Collection<NaviNode> nodes, boolean visible) {
        Preconditions.checkNotNull(parent, "IE02123: Parent argument can not be null");
        Preconditions.checkNotNull(graph, "IE02124: Graph argument can not be null");
        Preconditions.checkNotNull(nodes, "IE02125: Nodes argument can not be null");
        if (visible) {
            ZyGraphViewSettings settings = graph.getSettings();
            Set<NaviNode> neighbours = ProximityRangeCalculator.getNeighbors(graph, nodes, settings.getProximitySettings().getProximityBrowsingChildren(), settings.getProximitySettings().getProximityBrowsingParents());
            neighbours.addAll(nodes);
            int invisibleNodes = CGraphFunctions.countInvisibleNodes(neighbours);
            if (CGraphFunctions.userCancelsMakingVisible(parent, graph, invisibleNodes)) {
                return;
            }
        }
        graph.showNodes(nodes, visible);
    }
}

