/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.ZyGraph.Implementations;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviEdge;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.gui.zygraph.EdgeHidingMode;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.IEdgeCallback;
import com.google.security.zynamics.zylib.types.common.IterationMode;

public final class CEdgeDrawingFunctions {
    private CEdgeDrawingFunctions() {
    }

    public static boolean calcDrawSloppyEdges(ZyGraph graph) {
        Preconditions.checkNotNull(graph, "IE02113: Graph argument can not be null");
        EdgeHidingMode mode = graph.getSettings().getEdgeSettings().getEdgeHidingMode();
        return mode == EdgeHidingMode.HIDE_NEVER || mode == EdgeHidingMode.HIDE_ON_THRESHOLD && graph.getSettings().getEdgeSettings().getEdgeHidingThreshold() > graph.getEdgeCount();
    }

    public static void initializeEdgeDrawingMode(final ZyGraph graph) {
        Preconditions.checkNotNull(graph, "IE02114: Graph argument can not be null");
        final boolean drawSloppyEdges = CEdgeDrawingFunctions.calcDrawSloppyEdges(graph);
        graph.iterateEdges(new IEdgeCallback<NaviEdge>(){

            @Override
            public IterationMode nextEdge(NaviEdge edge) {
                edge.initializeDrawingMode(graph, drawSloppyEdges);
                return IterationMode.CONTINUE;
            }
        });
    }
}

