/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.ZyGraph.Builders;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.security.zynamics.binnavi.ZyGraph.Builders.Modifiers.INodeModifier;
import com.google.security.zynamics.binnavi.ZyGraph.Builders.ZyNodeBuilder;
import com.google.security.zynamics.binnavi.ZyGraph.ZyGraphViewSettings;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.INaviFunctionNode;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.CStyleRunData;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLabelContent;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLineContent;
import java.awt.Color;
import java.awt.Font;

public final class ZyFunctionNodeBuilder {
    private static final Font BOLD_FONT = new Font(GuiHelper.getMonospaceFont(), 1, 12);
    private static final Font NORMAL_FONT = new Font(GuiHelper.getMonospaceFont(), 0, 12);

    private ZyFunctionNodeBuilder() {
    }

    private static void buildAddressLine(INaviFunctionNode node, ZyLabelContent content, INodeModifier modifier) {
        String module = node.getFunction().getModule().getConfiguration().getName();
        String standardAddress = node.getFunction().getAddress().toHexString();
        String address = modifier == null ? standardAddress : modifier.getAddress(node);
        CStyleRunData styleRun = address.equals(standardAddress) ? new CStyleRunData(0, -1, Color.BLACK) : new CStyleRunData(0, -1, Color.RED);
        ZyLineContent addressLine = new ZyLineContent(new StringBuilder(2 + String.valueOf(module).length() + String.valueOf(address).length()).append(module).append("::").append(address).toString(), BOLD_FONT, Lists.newArrayList(styleRun), null);
        content.addLineContent(addressLine);
    }

    private static void buildNameLine(INaviFunctionNode node, ZyLabelContent content, boolean showFunctionInformation) {
        INaviFunction function = node.getFunction();
        String informationString = "";
        if (function.getBasicBlockCount() > 0) {
            StringBuilder builder = new StringBuilder();
            builder.append(" (");
            builder.append(function.getBasicBlockCount());
            builder.append(" basic block");
            if (function.getBasicBlockCount() > 1) {
                builder.append('s');
            }
            if (function.getEdgeCount() > 0) {
                builder.append(", ");
                builder.append(function.getEdgeCount());
                builder.append(" edge");
                if (function.getEdgeCount() > 1) {
                    builder.append('s');
                }
            }
            builder.append(')');
            informationString = builder.toString();
        }
        String string2 = String.valueOf(function.getName());
        String string3 = String.valueOf(informationString);
        ZyLineContent nameLine = new ZyLineContent(string3.length() != 0 ? string2.concat(string3) : new String(string2), NORMAL_FONT, null);
        content.addLineContent(nameLine);
    }

    public static ZyLabelContent buildContent(INaviFunctionNode node, ZyGraphViewSettings graphSettings, INodeModifier modifier) {
        Preconditions.checkNotNull(node, "IE01556: Argument node can't be null");
        ZyLabelContent content = new ZyLabelContent(null);
        ZyFunctionNodeBuilder.buildContent(content, node, graphSettings, modifier);
        return content;
    }

    public static void buildContent(ZyLabelContent content, INaviFunctionNode node, ZyGraphViewSettings graphSettings, INodeModifier modifier) {
        Preconditions.checkNotNull(node, "IE00903: Argument node can't be null");
        while (content.getLineCount() != 0) {
            content.removeLine(0);
        }
        ZyFunctionNodeBuilder.buildAddressLine(node, content, modifier);
        ZyFunctionNodeBuilder.buildNameLine(node, content, graphSettings.getDisplaySettings().getFunctionNodeInformation());
        ZyNodeBuilder.addCommentTagLines(content, node, node.getLocalFunctionComment(), node.getFunction().getGlobalComment());
    }
}

