/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.ZyGraph.Builders.Modifiers;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.ZyGraph.Builders.Modifiers.INodeModifier;
import com.google.security.zynamics.binnavi.ZyGraph.ZyGraphViewSettings;
import com.google.security.zynamics.binnavi.debug.debugger.BackEndDebuggerProvider;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.disassembly.INaviFunctionNode;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.UnrelocatedAddress;

public final class CDefaultModifier
implements INodeModifier {
    private final ZyGraphViewSettings m_settings;
    private final BackEndDebuggerProvider m_provider;

    public CDefaultModifier(ZyGraphViewSettings settings, BackEndDebuggerProvider provider) {
        this.m_settings = Preconditions.checkNotNull(settings, "IE02109: Settings argument can not be null");
        this.m_provider = Preconditions.checkNotNull(provider, "IE02110: Provider argument can not be null");
    }

    @Override
    public String getAddress(INaviInstruction instruction) {
        return this.getAddress(instruction.getModule(), new UnrelocatedAddress(instruction.getAddress()), true);
    }

    @Override
    public String getAddress(INaviFunctionNode node) {
        return this.getAddress(node.getFunction().getModule(), new UnrelocatedAddress(node.getFunction().getAddress()), true);
    }

    @Override
    public String getAddress(INaviModule module, UnrelocatedAddress address, boolean pad) {
        IDebugger debugger = this.m_provider.getDebugger(module);
        if (debugger != null && this.m_settings.getDisplaySettings().getShowMemoryAddresses(debugger)) {
            return pad ? debugger.fileToMemory(module, address).getAddress().toHexString() : debugger.fileToMemory(module, address).getAddress().toBigInteger().toString(16).toUpperCase();
        }
        return pad ? address.getAddress().toHexString() : address.getAddress().toBigInteger().toString(16).toUpperCase();
    }
}

