/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.ZyGraph.Builders;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.Gui.Users.Interfaces.IUser;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class CommentContainer {
    final IComment comment;
    final String userNameDelimiter = ": ";
    final Color commentColor;

    public CommentContainer(IComment comment) {
        this.comment = Preconditions.checkNotNull(comment, "IE02730: comment argument can not be null");
        String string2 = String.valueOf(String.valueOf(comment.getUser().getUserId()));
        this.commentColor = Color.getHSBColor(Float.parseFloat(new StringBuilder(3 + String.valueOf(string2).length()).append("0.").append(string2).append("f").toString()), 1.0f, 0.8f);
    }

    public IComment getComment() {
        return this.comment;
    }

    public Color getCommentColor() {
        return this.commentColor;
    }

    public List<String> getCommentingString() {
        if (this.comment == null) {
            return null;
        }
        if (this.comment.getComment().split("\\n").length <= 1) {
            String[] stringArray = new String[1];
            String string2 = this.comment.getUser().getUserName();
            String string3 = String.valueOf(": ");
            String string4 = this.comment.getComment();
            stringArray[0] = new StringBuilder(0 + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append(string2).append(string3).append(string4).toString();
            return Lists.newArrayList(stringArray);
        }
        if (this.comment.getComment().split("\\n").length > 1) {
            String[] commentFragments = this.comment.getComment().split("\\n");
            String[] stringArray = new String[1];
            String string5 = this.comment.getUser().getUserName();
            String string6 = String.valueOf(": ");
            String string7 = commentFragments[0];
            stringArray[0] = new StringBuilder(0 + String.valueOf(string5).length() + String.valueOf(string6).length() + String.valueOf(string7).length()).append(string5).append(string6).append(string7).toString();
            ArrayList<String> generatedComment = Lists.newArrayList(stringArray);
            for (int i2 = 1; i2 < commentFragments.length; ++i2) {
                String string8 = String.valueOf(Strings.repeat(" ", this.comment.getUser().getUserName().length() + ": ".length()));
                String string9 = String.valueOf(commentFragments[i2]);
                generatedComment.add(string9.length() != 0 ? string8.concat(string9) : new String(string8));
            }
            return generatedComment;
        }
        return null;
    }

    public IUser getCommentUser() {
        return this.comment.getUser();
    }

    public int getCommentUserNameLength() {
        return this.comment.getUser().getUserName().length();
    }

    public int getUserNameDelimiterLength() {
        return this.userNameDelimiter.length();
    }
}

