/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Tutorials;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;

public final class CTutorialStep {
    private final String m_description;
    private final List<Long> m_mandatory;
    private final List<Long> m_allowed;
    private final boolean m_next;

    public CTutorialStep(String description, List<Long> mandatory, List<Long> allowed, boolean next) {
        Preconditions.checkNotNull(description, "IE01003: Description argument can not be null");
        Preconditions.checkNotNull(mandatory, "IE01004: Mandatory argument can not be null");
        Preconditions.checkNotNull(allowed, "IE01005: Allowed argument can not be null");
        this.m_description = description;
        this.m_mandatory = new ArrayList<Long>(mandatory);
        this.m_allowed = new ArrayList<Long>(allowed);
        this.m_next = next;
    }

    public boolean canNext() {
        return this.m_next;
    }

    public String getDescription() {
        return this.m_description;
    }

    public boolean handles(long identifier) {
        return this.m_mandatory.contains(identifier) || this.m_allowed.contains(identifier);
    }

    public boolean mandates(long identifier) {
        return this.m_mandatory.contains(identifier);
    }
}

