/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Tutorials;

import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Tutorials.CTutorial;
import com.google.security.zynamics.binnavi.Tutorials.CTutorialStep;
import com.google.security.zynamics.zylib.io.DirUtils;
import com.google.security.zynamics.zylib.io.IDirectoryTraversalCallback;
import com.google.security.zynamics.zylib.types.lists.FilledList;
import com.google.security.zynamics.zylib.types.lists.IFilledList;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class CTutorialLoader {
    private CTutorialLoader() {
    }

    private static CTutorial loadTutorial(File file) throws ParserConfigurationException, SAXException, IOException {
        String name = "";
        String description = "";
        ArrayList<CTutorialStep> steps = new ArrayList<CTutorialStep>();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(file);
        NodeList nodes = document.getFirstChild().getChildNodes();
        for (int i2 = 0; i2 < nodes.getLength(); ++i2) {
            Node node = nodes.item(i2);
            String nodeName = node.getNodeName();
            if ("name".equals(nodeName)) {
                name = node.getTextContent();
                continue;
            }
            if ("description".equals(nodeName)) {
                description = node.getTextContent();
                continue;
            }
            if (!"steps".equals(nodeName)) continue;
            steps.addAll(CTutorialLoader.readSteps(node));
        }
        return new CTutorial(name, description, steps);
    }

    private static List<CTutorialStep> readSteps(Node node) {
        ArrayList<CTutorialStep> steps = new ArrayList<CTutorialStep>();
        for (int i2 = 0; i2 < node.getChildNodes().getLength(); ++i2) {
            Node child = node.getChildNodes().item(i2);
            String childText = child.getNodeName();
            if (!"step".equals(childText)) continue;
            ArrayList<Long> identifiers = new ArrayList<Long>();
            ArrayList<Long> allows = new ArrayList<Long>();
            String actionDescription = null;
            boolean next = false;
            for (int j2 = 0; j2 < child.getChildNodes().getLength(); ++j2) {
                long index;
                Node child2 = child.getChildNodes().item(j2);
                String childName = child2.getNodeName();
                if ("action".equals(childName)) {
                    index = Long.valueOf(child2.getTextContent());
                    if (index == 0L) {
                        next = true;
                        continue;
                    }
                    identifiers.add(index);
                    continue;
                }
                if ("allowed".equals(childName)) {
                    index = Long.valueOf(child2.getTextContent());
                    allows.add(index);
                    continue;
                }
                if (!"description".equals(childName)) continue;
                actionDescription = child2.getTextContent();
            }
            steps.add(new CTutorialStep(actionDescription, identifiers, allows, next));
        }
        return steps;
    }

    public static IFilledList<CTutorial> readTutorials(String directory) {
        final FilledList<CTutorial> tutorials = new FilledList<CTutorial>();
        DirUtils.traverse(new File(directory), new IDirectoryTraversalCallback(){

            @Override
            public void entering(File directory) {
            }

            @Override
            public void leaving(File directory) {
            }

            @Override
            public void nextFile(File file) {
                if (file.getAbsolutePath().endsWith("xml")) {
                    try {
                        tutorials.add(CTutorialLoader.loadTutorial(file));
                    }
                    catch (ParserConfigurationException e2) {
                        CUtilityFunctions.logException(e2);
                    }
                    catch (SAXException e3) {
                        CUtilityFunctions.logException(e3);
                    }
                    catch (IOException e4) {
                        CUtilityFunctions.logException(e4);
                    }
                }
            }
        });
        return tutorials;
    }
}

