/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Startup;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Gui.Scripting.ScriptLoader;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.Plugins.DisabledPluginReason;
import com.google.security.zynamics.binnavi.Plugins.IPluginRegistry;
import com.google.security.zynamics.binnavi.Plugins.JarLoader;
import com.google.security.zynamics.binnavi.Plugins.LoadResult;
import com.google.security.zynamics.binnavi.Plugins.PluginInitializer;
import com.google.security.zynamics.binnavi.Plugins.PluginLoader;
import com.google.security.zynamics.binnavi.Plugins.PluginStatus;
import com.google.security.zynamics.binnavi.api2.plugins.IPlugin;
import com.google.security.zynamics.binnavi.config.ConfigManager;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.CStandardHelperThread;
import java.awt.Window;
import java.io.File;
import java.util.List;
import java.util.Set;

public final class PluginLoaderThread<T>
extends CStandardHelperThread {
    private final Window parent;
    private final String rootPath;
    private final List<String> pluginPaths;
    private final T pluginInterface;
    private final IPluginRegistry<IPlugin<T>> registry;
    private final ConfigManager configFile;

    public PluginLoaderThread(Window parent, String rootPath, List<String> pluginPaths, T pluginInterface, IPluginRegistry<IPlugin<T>> registry, ConfigManager configFile) {
        this.rootPath = Preconditions.checkNotNull(rootPath, "IE02094: Root path argument can not be null");
        this.pluginPaths = Preconditions.checkNotNull(pluginPaths, "IE02095: Plugin paths argument can not be null");
        this.pluginInterface = Preconditions.checkNotNull(pluginInterface, "IE02096: Plugin interface argument can not be null");
        this.registry = Preconditions.checkNotNull(registry, "IE02097: Registry argument can not be null");
        this.configFile = Preconditions.checkNotNull(configFile, "IE02098: Config file argument can not be null");
        this.parent = parent;
    }

    private static <T> IPlugin<T> getPluginWithGuid(Iterable<Pair<IPlugin<T>, PluginStatus>> plugins, long guid) {
        for (Pair<IPlugin<T>, PluginStatus> plugin : plugins) {
            if (plugin.first().getGuid() != guid) continue;
            return plugin.first();
        }
        return null;
    }

    private void showError(LoadResult<T> plugins, IPlugin<T> plugin, PluginStatus pluginStatus) {
        String message2 = "";
        String description = "";
        switch (pluginStatus) {
            case DuplicateGuid: {
                message2 = "E00009: Detected a GUID collision between two plugins";
                description = CUtilityFunctions.createDescription(String.format("BinNavi could not load the plugins '%s' and '%s' because they share the same GUID.", plugin.getName(), PluginLoaderThread.getPluginWithGuid(plugins.getLoadedPlugins(), plugin.getGuid()).getName()), new String[]{"Plugin GUIDs have to be unique but two plugins share the same GUID."}, new String[]{"Neither of the two plugins is loaded until the plugin authors resolve their GUID collision."});
                break;
            }
            case InvalidGuid: {
                message2 = "E00010: Detected a plugin with an invalid GUID";
                description = CUtilityFunctions.createDescription(String.format("The plugin '%s' has the invalid GUID %d.", plugin.getName(), plugin.getGuid()), new String[]{"Certain values are not valid for plugin GUIDs. The specified plugin uses such an invalid GUID."}, new String[]{"The plugin is not loaded until the plugin author changes the GUID of this plugin."});
                break;
            }
            case InvalidName: {
                message2 = "E00011: Detected a plugin with an invalid name";
                description = CUtilityFunctions.createDescription(String.format("The plugin with GUID %d has the invalid name '%s'.", plugin.getGuid(), plugin.getName()), new String[]{"Certain values are not valid for plugin names. The specified plugin uses such an invalid name."}, new String[]{"The plugin is not loaded until the plugin author changes the name of this plugin."});
                break;
            }
            case InvalidNameGuid: {
                message2 = "E00103: Detected a plugin with an invalid name and an invalid GUID";
                description = CUtilityFunctions.createDescription(String.format("The plugin with GUID %d has the invalid name '%s'.", plugin.getGuid(), plugin.getName()), new String[]{"Certain values are not valid for plugin names and plugin GUIDs. The specified plugin uses such an invalid name and an invalid GUID."}, new String[]{"The plugin is not loaded until the plugin author changes the name and the GUID of this plugin."});
                break;
            }
            default: {
                throw new IllegalStateException("IE00001: Encountered an invalid plugin status");
            }
        }
        NaviErrorDialog.show(this.parent, message2, description);
    }

    @Override
    protected void runExpensiveCommand() throws Exception {
        this.setDescription("Loading JAR files");
        Set<File> jarFiles = JarLoader.collectJars(this.rootPath);
        JarLoader.loadJars(jarFiles, this);
        Set<File> scriptFiles = ScriptLoader.collectScripts(this.rootPath);
        ScriptLoader.init(scriptFiles, this.pluginInterface, this);
        List<IPlugin<T>> scriptPlugins = this.registry.getPlugins();
        for (String pluginPath : this.pluginPaths) {
            IPlugin plugin;
            Set<File> pluginFiles = PluginLoader.collectPluginFiles(pluginPath);
            LoadResult plugins = PluginLoader.loadPlugins(pluginPath, pluginFiles, this);
            for (Pair<String, Throwable> pair : plugins.getFailedPlugins()) {
                CUtilityFunctions.logException(pair.second());
                String message2 = "E00007: Loading a plugin failed";
                String description = CUtilityFunctions.createDescription(String.format("BinNavi could not load the plugin file file '%s' because the plugin caused an exception.", pair.first()), new String[]{"The plugin file contains a bug that caused the exception"}, new String[]{"The plugin file was not loaded and the functionality of the script will not be available in BinNavi"});
                NaviErrorDialog.show(this.parent, "E00007: Loading a plugin failed", description, pair.second());
            }
            for (Pair<Object, Object> pair : plugins.getLoadedPlugins()) {
                plugin = (IPlugin)pair.first();
                PluginStatus status = (PluginStatus)((Object)pair.second());
                if (status == PluginStatus.Valid) continue;
                this.showError(plugins, plugin, status);
            }
            PluginInitializer.initializePlugins(this.pluginInterface, this.registry, plugins.getLoadedPlugins(), this.configFile);
            for (IPlugin iPlugin : scriptPlugins) {
                try {
                    iPlugin.init(this.pluginInterface);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                    this.registry.removePlugin(iPlugin, DisabledPluginReason.ThrewOnInit);
                }
            }
            for (Pair pair : this.registry.getDisabledPlugins()) {
                plugin = (IPlugin)pair.first();
                DisabledPluginReason reason = (DisabledPluginReason)((Object)pair.second());
                if (reason != DisabledPluginReason.ThrewOnInit) continue;
                String message3 = "E00102: Error during plugin initialization";
                String description = CUtilityFunctions.createDescription(String.format("BinNavi could not initialize the plugin '%s' because the plugin caused an exception.", plugin.getName()), new String[]{"A bug in the plugin caused an exception."}, new String[]{"The plugin could not be initialized properly and was removed from the list of loaded plugins."});
                NaviErrorDialog.show(this.parent, "E00102: Error during plugin initialization", description);
            }
        }
    }
}

