/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Startup;

import com.google.security.zynamics.binnavi.Gui.HotKeys;
import com.google.security.zynamics.binnavi.Log.NaviLogger;
import com.google.security.zynamics.binnavi.config.ConfigManager;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import java.awt.Font;
import java.util.logging.Level;
import javax.swing.InputMap;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;

public final class GuiInitializer {
    private GuiInitializer() {
    }

    private static void initializeFont() {
        Font font = new Font(GuiHelper.getDefaultFont(), 0, 12);
        NaviLogger.info("Determined default font: %s", GuiHelper.getDefaultFont());
        NaviLogger.info("Using default font: %s", font.getPSName());
        NaviLogger.info("Determined monospaced font: %s", GuiHelper.getMonospaceFont());
        NaviLogger.info("Using monospaced font: %s", GuiHelper.MONOSPACED_FONT.getPSName());
        UIManager.put("Button.font", font);
        UIManager.put("CheckBox.font", font);
        UIManager.put("CheckBoxMenuItem.font", font);
        UIManager.put("ColorChooser.font", font);
        UIManager.put("ComboBox.font", font);
        UIManager.put("DesktopIcon.font", font);
        UIManager.put("InternalFrame.font", font);
        UIManager.put("InternalFrame.titleFont", font);
        UIManager.put("Label.font", font);
        UIManager.put("List.font", font);
        UIManager.put("Menu.font", font);
        UIManager.put("MenuBar.font", font);
        UIManager.put("MenuItem.font", font);
        UIManager.put("OptionPane.font", font);
        UIManager.put("Panel.font", font);
        UIManager.put("PasswordField.font", font);
        UIManager.put("PopupMenu.font", font);
        UIManager.put("ProgressBar.font", font);
        UIManager.put("RadioButton.font", font);
        UIManager.put("RadioButtonMenuItem.font", font);
        UIManager.put("ScrollPane.font", font);
        UIManager.put("TabbedPane.font", font);
        UIManager.put("Table.font", font);
        UIManager.put("TableHeader.font", font);
        UIManager.put("Text.font", font);
        UIManager.put("TextArea.font", font);
        UIManager.put("TextField.font", font);
        UIManager.put("TitledBorder.font", font);
        UIManager.put("ToggleButton.font", font);
        UIManager.put("ToolBar.font", font);
        UIManager.put("ToolTip.font", font);
        UIManager.put("Tree.font", font);
        UIManager.put("Viewport.font", font);
    }

    private static void initializeHotkeys() {
        InputMap map = (InputMap)UIManager.get("SplitPane.ancestorInputMap");
        map.remove(HotKeys.GUI_INITIALIZER_KEY_1.getKeyStroke());
        map.remove(HotKeys.GUI_INITIALIZER_KEY_2.getKeyStroke());
    }

    private static void initializeLogging() {
        switch (ConfigManager.instance().getGeneralSettings().getLogLevel()) {
            case 0: {
                NaviLogger.setLevel(Level.OFF);
                break;
            }
            case 1: {
                NaviLogger.setLevel(Level.INFO);
                break;
            }
            case 2: {
                NaviLogger.setLevel(Level.ALL);
                break;
            }
            default: {
                throw new IllegalStateException("IE00844: Unknown log level read from configuration file");
            }
        }
    }

    private static void initializeTooltipDelay() {
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.setDismissDelay(60000);
        toolTipManager.setInitialDelay(1000);
        toolTipManager.setReshowDelay(1000);
    }

    public static void initialize() {
        GuiInitializer.initializeLogging();
        System.setProperty(CMessageBox.DEFAULT_WINDOW_TITLE_PROPERTY, "BinNavi");
        GuiInitializer.initializeFont();
        GuiInitializer.initializeTooltipDelay();
        GuiInitializer.initializeHotkeys();
    }
}

