/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Startup;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Log.NaviLogger;
import com.google.security.zynamics.binnavi.Startup.CommandlineOptions;
import java.util.logging.Level;

public final class CommandlineParser {
    private CommandlineParser() {
    }

    private static void processCommandLineOptions(CommandlineOptions commandLine) {
        if (commandLine.isVeryVerboseMode()) {
            NaviLogger.setLevel(Level.ALL);
        } else if (commandLine.isVerboseMode()) {
            NaviLogger.setLevel(Level.INFO);
        }
    }

    public static CommandlineOptions parseCommandLine(String[] arguments2) {
        Preconditions.checkNotNull(arguments2, "IE02087: Arguments argument can not be null");
        CommandlineOptions options = new CommandlineOptions();
        for (String argument : arguments2) {
            if ("-v".equals(argument)) {
                options.setVerboseMode();
                continue;
            }
            if ("-vv".equals(argument)) {
                options.setVeryVerboseMode();
                continue;
            }
            if (!argument.startsWith("-X:")) continue;
            options.setBatchPlugin(arguments2[0].substring(3));
        }
        CommandlineParser.processCommandLineOptions(options);
        return options;
    }
}

