/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Startup;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Gui.CProgressDialog;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.Log.NaviLogger;
import com.google.security.zynamics.binnavi.Plugins.IPluginRegistry;
import com.google.security.zynamics.binnavi.Startup.PluginLoaderThread;
import com.google.security.zynamics.binnavi.api2.plugins.IPlugin;
import com.google.security.zynamics.binnavi.config.ConfigManager;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;

public final class CPluginLoader {
    private CPluginLoader() {
    }

    public static <T> void loadPlugins(Window parent, T pluginInterface, IPluginRegistry<IPlugin<T>> registry, String startPath, ConfigManager configFile) {
        Preconditions.checkNotNull(pluginInterface, "IE02089: Plugin interface argument can not be null");
        Preconditions.checkNotNull(registry, "IE02090: Registry argument can not be null");
        Preconditions.checkNotNull(startPath, "IE02091: Start path argument can not be null");
        Preconditions.checkNotNull(configFile, "IE02092: Config file argument can not be null");
        String[] stringArray = new String[2];
        Object object = String.valueOf(File.separator);
        stringArray[0] = new StringBuilder(7 + String.valueOf(startPath).length() + String.valueOf(object).length()).append(startPath).append((String)object).append("plugins").toString();
        object = String.valueOf(File.separator);
        stringArray[1] = new StringBuilder(11 + String.valueOf(startPath).length() + String.valueOf(object).length()).append(startPath).append((String)object).append("userplugins").toString();
        ArrayList<String> pluginPaths = Lists.newArrayList(stringArray);
        for (String pluginPath : pluginPaths) {
            NaviLogger.info(String.format("Loading plugins from %s", pluginPath), new Object[0]);
        }
        PluginLoaderThread<T> thread2 = new PluginLoaderThread<T>(parent, startPath, pluginPaths, pluginInterface, registry, configFile);
        CProgressDialog.show(parent, "Loading plugins ...", thread2);
        if (thread2.getException() != null) {
            CUtilityFunctions.logException(thread2.getException());
            String message2 = "E00104: An unexpected problem occurred while the plugins were loaded";
            String description = CUtilityFunctions.createDescription("It is unclear what caused this problem. Please check the stack trace for more information. If the stack trace does not help you fix this problem please contact the BinNavi support.", new String[0], new String[0]);
            NaviErrorDialog.show(null, "E00104: An unexpected problem occurred while the plugins were loaded", description, thread2.getException());
        }
    }
}

