/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Startup;

import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.Log.NaviLogFormatter;
import com.google.security.zynamics.binnavi.Log.NaviLogger;
import com.google.security.zynamics.binnavi.config.ConfigManager;
import com.google.security.zynamics.binnavi.config.FileReadException;
import com.google.security.zynamics.common.config.ConfigHelper;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import java.io.File;
import java.io.IOException;
import java.util.logging.FileHandler;

public final class CConfigurationFileCreator {
    private static final String NAVI_LOG_FILE = String.valueOf(ConfigHelper.getConfigurationDirectory("zynamics", "BinNavi")).concat("navilog.txt");
    private static final int MAX_LOG_FILE_SIZE = 0x40000000;
    private static final int LOG_ROTATE_COUNT = 5;

    private CConfigurationFileCreator() {
    }

    public static boolean setupConfigurationFile() {
        try {
            FileHandler fileHandler = new FileHandler(NAVI_LOG_FILE, 0x40000000, 5);
            fileHandler.setFormatter(new NaviLogFormatter());
            NaviLogger.addHandler(fileHandler);
        }
        catch (IOException exception) {
            CUtilityFunctions.logException(exception);
            String message2 = "E00002: Could not create the log file";
            String description = CUtilityFunctions.createDescription(String.format("BinNavi could not create the log file '%s'.", NAVI_LOG_FILE), new String[]{"Some kind of IO problem occurred. Please check the stack trace for more details"}, new String[]{"The error log file can not be stored"});
            NaviErrorDialog.show(null, "E00002: Could not create the log file", description, exception);
        }
        NaviLogger.info("Loading configuration file", new Object[0]);
        try {
            return ConfigManager.instance().read();
        }
        catch (FileReadException exception) {
            File file;
            CUtilityFunctions.logException(exception);
            String configFileName = ConfigHelper.getConfigFileName("zynamics", "BinNavi", "config.xml");
            String message3 = "E00003: Malformed configuration file";
            String description = CUtilityFunctions.createDescription(String.format("The configuration file '%s' could not be read because it contains malformed XML.", configFileName), new String[]{"You edited the configuration file manually and made a mistake", "The configuration file was corrupted randomly"}, new String[]{"After closing this dialog you will be asked if you want to run BinNavi with default settings or if you want to repair the configuration file manually."});
            NaviErrorDialog.show(null, "E00003: Malformed configuration file", description, exception);
            if (0 != CMessageBox.showYesNoQuestion(null, "Do you want to run BinNavi with default settings? If you choose 'No', BinNavi will exit so you can repair the configuration file manually.")) {
                System.exit(0);
            }
            if (!(file = new File(configFileName)).delete()) {
                String innerMessage = "E00004: Could not delete malformed configuration file";
                String innerDescription = CUtilityFunctions.createDescription(String.format("The malformed configuration file '%s' could not be deleted.", configFileName), new String[]{"The configuration file is in use by another program", "Some kind of IO problem occurred"}, new String[]{"BinNavi will exit after you close this error dialog and you will have to delete or fix the malformed configuration file manually."});
                NaviErrorDialog.show(null, "E00004: Could not delete malformed configuration file", innerDescription);
                System.exit(0);
            }
            try {
                return ConfigManager.instance().read();
            }
            catch (FileReadException e2) {
                String innerMessage = "E00005: Could not create configuration file";
                String innerDescription = CUtilityFunctions.createDescription(String.format("BinNavi could not create the new configuration file '%s'.", configFileName), new String[]{"Some kind of IO problem occurred"}, new String[]{"BinNavi will exit after you close this error dialog. Try to find out why the configuration file could not be created. You may also want to contact the BinNavi support at this point."});
                NaviErrorDialog.show(null, "E00005: Could not create configuration file", innerDescription);
                System.exit(0);
                return false;
            }
        }
    }
}

