/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.REIL;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.API.disassembly.EdgeType;
import com.google.security.zynamics.binnavi.API.reil.ReilBlock;
import com.google.security.zynamics.binnavi.API.reil.ReilEdge;
import com.google.security.zynamics.binnavi.API.reil.ReilGraph;
import com.google.security.zynamics.binnavi.API.reil.ReilInstruction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class ReilGraphConverter {
    private ReilGraphConverter() {
    }

    private static List<com.google.security.zynamics.reil.ReilInstruction> convert(List<ReilInstruction> instructions) {
        ArrayList<com.google.security.zynamics.reil.ReilInstruction> convertedInstructions = new ArrayList<com.google.security.zynamics.reil.ReilInstruction>();
        for (ReilInstruction reilInstruction : instructions) {
            convertedInstructions.add(reilInstruction.getNative());
        }
        return convertedInstructions;
    }

    public static com.google.security.zynamics.reil.ReilGraph convert(ReilGraph graph) {
        Preconditions.checkNotNull(graph, "IE01050: Graph argument can not be null");
        ArrayList<com.google.security.zynamics.reil.ReilBlock> nodes = new ArrayList<com.google.security.zynamics.reil.ReilBlock>();
        HashMap<ReilBlock, com.google.security.zynamics.reil.ReilBlock> blockMap = new HashMap<ReilBlock, com.google.security.zynamics.reil.ReilBlock>();
        for (ReilBlock reilBlock : graph) {
            com.google.security.zynamics.reil.ReilBlock convertedBlock = new com.google.security.zynamics.reil.ReilBlock(ReilGraphConverter.convert(reilBlock.getInstructions()));
            blockMap.put(reilBlock, convertedBlock);
            nodes.add(convertedBlock);
        }
        ArrayList<com.google.security.zynamics.reil.ReilEdge> edges = new ArrayList<com.google.security.zynamics.reil.ReilEdge>();
        for (ReilEdge edge : graph.getEdges()) {
            com.google.security.zynamics.reil.ReilEdge convertedEdge = new com.google.security.zynamics.reil.ReilEdge((com.google.security.zynamics.reil.ReilBlock)blockMap.get(edge.getSource()), (com.google.security.zynamics.reil.ReilBlock)blockMap.get(edge.getTarget()), edge.getType().getNative());
            edges.add(convertedEdge);
            com.google.security.zynamics.reil.ReilBlock.link((com.google.security.zynamics.reil.ReilBlock)blockMap.get(edge.getSource()), (com.google.security.zynamics.reil.ReilBlock)blockMap.get(edge.getTarget()), convertedEdge);
        }
        return new com.google.security.zynamics.reil.ReilGraph((List<com.google.security.zynamics.reil.ReilBlock>)nodes, (List<com.google.security.zynamics.reil.ReilEdge>)edges);
    }

    public static ReilGraph createReilGraph(com.google.security.zynamics.reil.ReilGraph graph) {
        Preconditions.checkNotNull(graph, "IE01049: Graph argument can not be null");
        ArrayList<ReilBlock> blocks = new ArrayList<ReilBlock>();
        ArrayList<ReilEdge> edges = new ArrayList<ReilEdge>();
        HashMap<com.google.security.zynamics.reil.ReilBlock, ReilBlock> blockMap = new HashMap<com.google.security.zynamics.reil.ReilBlock, ReilBlock>();
        for (com.google.security.zynamics.reil.ReilBlock block : graph.getNodes()) {
            ReilBlock newBlock = new ReilBlock(block);
            blockMap.put(block, newBlock);
            blocks.add(newBlock);
        }
        for (com.google.security.zynamics.reil.ReilEdge edge : graph.getEdges()) {
            ReilBlock source = (ReilBlock)blockMap.get(edge.getSource());
            ReilBlock target = (ReilBlock)blockMap.get(edge.getTarget());
            edges.add(new ReilEdge(source, target, EdgeType.convert(edge.getType())));
        }
        return new ReilGraph((List<ReilBlock>)blocks, (List<ReilEdge>)edges);
    }
}

