/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.REIL;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.API.disassembly.BasicBlock;
import com.google.security.zynamics.binnavi.API.disassembly.CodeNode;
import com.google.security.zynamics.binnavi.API.disassembly.Function;
import com.google.security.zynamics.binnavi.API.disassembly.Instruction;
import com.google.security.zynamics.binnavi.API.disassembly.View;
import com.google.security.zynamics.binnavi.API.disassembly.ViewNode;
import com.google.security.zynamics.zylib.disassembly.IInstruction;

public final class InstructionFinders {
    private InstructionFinders() {
    }

    public static Instruction findInstruction(BasicBlock block, IInstruction searchInstruction) {
        Preconditions.checkNotNull(block, "IE02005: Block argument can not be null");
        Preconditions.checkNotNull(searchInstruction, "IE02012: Instruction argument can not be null");
        for (Instruction instruction : block.getInstructions()) {
            if (instruction.getNative() != searchInstruction) continue;
            return instruction;
        }
        throw new IllegalStateException("IE01272: Could not determine what instruction could not be translated");
    }

    public static Instruction findInstruction(CodeNode codeNode, IInstruction searchInstruction) {
        Preconditions.checkNotNull(codeNode, "IE02027: Code node argument can not be null");
        Preconditions.checkNotNull(searchInstruction, "IE02033: Instruction argument can not be null");
        for (Instruction instruction : codeNode.getInstructions()) {
            if (instruction.getNative() != searchInstruction) continue;
            return instruction;
        }
        throw new IllegalStateException("IE01273: Could not determine what instruction could not be translated");
    }

    public static Instruction findInstruction(Function function, IInstruction searchInstruction) {
        Preconditions.checkNotNull(function, "IE02034: Function argument can not be null");
        Preconditions.checkNotNull(searchInstruction, "IE02052: Instruction argument can not be null");
        for (BasicBlock block : function.getGraph().getNodes()) {
            for (Instruction instruction : block.getInstructions()) {
                if (instruction.getNative() != searchInstruction) continue;
                return instruction;
            }
        }
        throw new IllegalStateException("IE01274: Could not determine what instruction could not be translated");
    }

    public static Instruction findInstruction(View view, IInstruction searchInstruction) {
        Preconditions.checkNotNull(view, "IE02056: View argument can not be null");
        Preconditions.checkNotNull(searchInstruction, "IE02060: Instruction argument can not be null");
        for (ViewNode node : view.getGraph().getNodes()) {
            if (!(node instanceof CodeNode)) continue;
            CodeNode codeNode = (CodeNode)node;
            for (Instruction instruction : codeNode.getInstructions()) {
                if (instruction.getNative() != searchInstruction) continue;
                return instruction;
            }
        }
        throw new IllegalStateException("IE01275: Could not determine what instruction could not be translated");
    }
}

