/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.REIL;

import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.reil.OperandType;
import com.google.security.zynamics.reil.ReilBlock;
import com.google.security.zynamics.reil.ReilGraph;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.ReilOperand;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.ReilTranslator;
import com.google.security.zynamics.reil.translators.StandardEnvironment;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.HashSet;
import java.util.Set;

public final class COperandsDeterminer {
    private COperandsDeterminer() {
    }

    private static boolean isRegister(ReilOperand operand, boolean translatingReil) {
        return operand.getType() == OperandType.REGISTER && (translatingReil || ReilHelpers.isNativeRegister(operand));
    }

    private static boolean writesThirdOperand(ReilInstruction reilInstruction, boolean translatingReil) {
        return ReilHelpers.writesThirdOperand(reilInstruction.getMnemonicCode()) && (translatingReil || ReilHelpers.isNativeRegister(reilInstruction.getThirdOperand()));
    }

    public static Pair<Set<String>, Set<String>> getRegisters(INaviInstruction instruction) throws InternalTranslationException {
        HashSet<String> inSet = new HashSet<String>();
        HashSet<String> outSet = new HashSet<String>();
        ReilTranslator<INaviInstruction> translator = new ReilTranslator<INaviInstruction>();
        ReilGraph reilCode = translator.translate((ITranslationEnvironment)new StandardEnvironment(), instruction);
        boolean translatingReil = instruction.getArchitecture().equals("REIL");
        for (ReilBlock reilBlock : reilCode) {
            for (ReilInstruction reilInstruction : reilBlock) {
                if (COperandsDeterminer.writesThirdOperand(reilInstruction, translatingReil)) {
                    outSet.add(reilInstruction.getThirdOperand().getValue());
                }
                if (!COperandsDeterminer.writesThirdOperand(reilInstruction, translatingReil) && COperandsDeterminer.isRegister(reilInstruction.getThirdOperand(), translatingReil)) {
                    inSet.add(reilInstruction.getThirdOperand().getValue());
                }
                if (COperandsDeterminer.isRegister(reilInstruction.getFirstOperand(), translatingReil)) {
                    inSet.add(reilInstruction.getFirstOperand().getValue());
                }
                if (!COperandsDeterminer.isRegister(reilInstruction.getSecondOperand(), translatingReil)) continue;
                inSet.add(reilInstruction.getSecondOperand().getValue());
            }
        }
        return new Pair<Set<String>, Set<String>>(inSet, outSet);
    }
}

