/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Importers;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Gui.IdaSelectionDialog.CIdaSelectionDialog;
import com.google.security.zynamics.binnavi.Gui.IdbSelection.CIdbSelectionDialog;
import com.google.security.zynamics.binnavi.Importers.CBaseExporter;
import com.google.security.zynamics.binnavi.Importers.CBinExportImporter;
import com.google.security.zynamics.binnavi.Importers.CFailedImport;
import com.google.security.zynamics.binnavi.Importers.ConfigFileException;
import com.google.security.zynamics.binnavi.Importers.ExporterException;
import com.google.security.zynamics.binnavi.Importers.ImportFailedException;
import com.google.security.zynamics.binnavi.config.ConfigManager;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import com.google.security.zynamics.zylib.system.IdaException;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.JFrame;

public final class CImporterFactory {
    private CImporterFactory() {
    }

    private static String getIdaDirectory(JFrame parent) throws FileNotFoundException {
        String newIdaLocation;
        String idaLocation = ConfigManager.instance().getGeneralSettings().getIdaDirectory();
        File idaExec = new File(idaLocation);
        if (idaExec.exists()) {
            return idaExec.getAbsolutePath();
        }
        while ((newIdaLocation = CImporterFactory.promptForIdaDirectory(parent)) == null) {
        }
        return newIdaLocation;
    }

    private static void importIdbFileInternal(String idaDirectory, String idbFile, IDatabase database, CBaseExporter exporter) throws ImportFailedException {
        try {
            exporter.importModule(idbFile, idaDirectory, database);
        }
        catch (ConfigFileException exception) {
            throw new ImportFailedException(String.format("Could not create the IDA2SQL temp file.\nImporting project failed.", new Object[0]));
        }
        catch (IdaException exception) {
            throw new ImportFailedException(String.format("Could not start IDA Pro.\nImporting project failed.", new Object[0]));
        }
        catch (ExporterException exception) {
            throw new ImportFailedException(exception.getLocalizedMessage());
        }
    }

    private static String promptForIdaDirectory(JFrame parent) throws FileNotFoundException {
        CMessageBox.showError(parent, "Could not locate IDA Pro. Please select the IDA Pro installation directory");
        CIdaSelectionDialog fileChooser = CIdaSelectionDialog.show(parent, ConfigManager.instance().getGeneralSettings().getIdaDirectory());
        if (fileChooser.getSelectedFile() != null) {
            File idaDirectory = fileChooser.getSelectedFile();
            if (!idaDirectory.exists()) {
                return null;
            }
            ConfigManager.instance().getGeneralSettings().setIdaDirectory(idaDirectory.getAbsolutePath());
            return idaDirectory.getAbsolutePath();
        }
        throw new FileNotFoundException("E00211: The IDA directory is invalid or not set, please configure the location of your IDA.");
    }

    private static void updatePreviousFiles(List<String> lastDirectories, List<File> selectedFiles) {
        int MAXIMUM_LIST_SIZE = 5;
        LinkedHashSet<String> selectedDirectories = new LinkedHashSet<String>();
        for (File file : selectedFiles) {
            selectedDirectories.add(file.getParent());
            if (selectedDirectories.size() != 5) continue;
            break;
        }
        for (String lastDirectory : lastDirectories) {
            selectedDirectories.add(lastDirectory);
            if (selectedDirectories.size() != 5) continue;
            break;
        }
        lastDirectories.clear();
        lastDirectories.addAll(selectedDirectories);
    }

    public static boolean importModules(JFrame parent, final IDatabase database, List<CFailedImport> failedImports) throws FileNotFoundException, InterruptedException, ExecutionException {
        List<Object> selectedFiles;
        Preconditions.checkNotNull(parent, "IE02358: parent argument can not be null");
        Preconditions.checkNotNull(database, "IE02359: database argument can not be null");
        Preconditions.checkNotNull(failedImports, "IE02361: failedImports argument can not be null");
        List<String> lastDirectories = ConfigManager.instance().getGeneralSettings().getIdbDirectories();
        CIdbSelectionDialog dialogIdb = CIdbSelectionDialog.show(parent, lastDirectories);
        List<Object> list = selectedFiles = dialogIdb == null ? new ArrayList() : dialogIdb.getSelectedFiles();
        if (selectedFiles.isEmpty()) {
            return false;
        }
        final CBinExportImporter exporter = new CBinExportImporter();
        ConfigManager.instance().getGeneralSettings().setDefaultExporter(dialogIdb.getSelectedExporter().ordinal());
        CImporterFactory.updatePreviousFiles(lastDirectories, selectedFiles);
        ExecutorService executor = Executors.newFixedThreadPool(dialogIdb.getNumberOfParallelImports());
        ArrayList<Future<CFailedImport>> results = new ArrayList<Future<CFailedImport>>();
        try {
            final String idaDirectory = CImporterFactory.getIdaDirectory(parent);
            for (final File file : selectedFiles) {
                if (!file.exists()) {
                    CMessageBox.showError(parent, String.format("The selected IDB file '%s' does not exist.", file.getAbsolutePath()));
                    continue;
                }
                results.add(executor.submit(new Callable<CFailedImport>(){

                    @Override
                    public CFailedImport call() {
                        try {
                            CImporterFactory.importIdbFileInternal(idaDirectory, file.getAbsolutePath(), database, exporter);
                            return null;
                        }
                        catch (ImportFailedException exception) {
                            CUtilityFunctions.logException(exception);
                            return new CFailedImport(file.getAbsolutePath(), exception);
                        }
                    }
                }));
            }
            for (Future future2 : results) {
                if (future2.get() == null) continue;
                failedImports.add((CFailedImport)future2.get());
            }
            return true;
        }
        catch (FileNotFoundException e2) {
            CUtilityFunctions.logException(e2);
            throw new FileNotFoundException(String.format("Invalid IDA Pro executable file.\nImporting project failed.", new Object[0]));
        }
    }
}

