/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Importers;

import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Importers.CBaseExporter;
import com.google.security.zynamics.binnavi.Importers.CImporterManager;
import com.google.security.zynamics.binnavi.Importers.ConfigFileException;
import com.google.security.zynamics.binnavi.Importers.ExporterException;
import com.google.security.zynamics.zylib.system.IdaException;
import com.google.security.zynamics.zylib.system.IdaHelpers;
import com.google.security.zynamics.zylib.system.SystemHelpers;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.UnknownFormatConversionException;

public final class CBinExportImporter
extends CBaseExporter {
    private static final String BINEXPORT_VERSION = "zynamics_binexport_9";
    private static final String BINEXPORT_IDC_FILE_CONTENT = "#include <idc.idc>\nstatic main() {\n  Batch(0);\n  Wait();\n  RunPlugin(\"zynamics_binexport_9\", 1);\n  Exit(0);\n}";
    private static final String BINEXPORT_IDC_FILE = "binexport.idc";

    private static Process createIdaProcess(String idaExe, String idbFileName, String host, int port, String user2, String password, String name) throws IdaException {
        String tempPath = SystemHelpers.getTempDirectory();
        String string2 = String.valueOf(tempPath);
        String string3 = String.valueOf(BINEXPORT_IDC_FILE);
        File idcFile = new File(string3.length() != 0 ? string2.concat(string3) : new String(string2));
        try {
            if (!idcFile.exists()) {
                idcFile.createNewFile();
            }
            FileWriter fw = new FileWriter(idcFile.getAbsoluteFile());
            BufferedWriter bw2 = new BufferedWriter(fw);
            bw2.write(BINEXPORT_IDC_FILE_CONTENT);
            bw2.close();
        }
        catch (IOException exception) {
            CUtilityFunctions.logException(exception);
        }
        String idcPath = idcFile.getAbsolutePath();
        String[] stringArray = new String[10];
        stringArray[0] = idaExe;
        stringArray[1] = "-A";
        String string4 = String.valueOf(host);
        stringArray[2] = string4.length() != 0 ? "-OExporterHost:".concat(string4) : new String("-OExporterHost:");
        stringArray[3] = new StringBuilder(26).append("-OExporterPort:").append(port).toString();
        String string5 = String.valueOf(user2);
        stringArray[4] = string5.length() != 0 ? "-OExporterUser:".concat(string5) : new String("-OExporterUser:");
        String string6 = String.valueOf(password);
        stringArray[5] = string6.length() != 0 ? "-OExporterPassword:".concat(string6) : new String("-OExporterPassword:");
        String string7 = String.valueOf(name);
        stringArray[6] = string7.length() != 0 ? "-OExporterDatabase:".concat(string7) : new String("-OExporterDatabase:");
        stringArray[7] = "-OExporterSchema:public";
        stringArray[8] = IdaHelpers.getSArgument(idcPath, SystemHelpers.isRunningWindows());
        stringArray[9] = idbFileName;
        ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
        try {
            Process processInfo = null;
            processBuilder.redirectErrorStream(true);
            processInfo = processBuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(processInfo.getInputStream()));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    System.out.println(line);
                }
            }
            catch (IOException exception) {
                reader.close();
            }
            reader.close();
            return processInfo;
        }
        catch (Exception exception) {
            try {
                CUtilityFunctions.logException(exception);
            }
            catch (UnknownFormatConversionException unknownFormatConversionException) {
                // empty catch block
            }
            String string8 = String.valueOf(exception);
            throw new IdaException(new StringBuilder(59 + String.valueOf(string8).length()).append("E00210: Failed attempting to launch the importer with IDA: ").append(string8).toString(), exception);
        }
    }

    private static String getHost(String host) {
        int colonIndex = host.indexOf(58);
        if (colonIndex == -1) {
            return host;
        }
        return host.substring(0, colonIndex);
    }

    private static int getPort(String host) {
        int colonIndex = host.indexOf(58);
        if (colonIndex == -1) {
            return 5432;
        }
        String portString = host.substring(colonIndex + 1);
        try {
            return Integer.valueOf(portString);
        }
        catch (NumberFormatException exception) {
            return 5432;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void importModuleInternal(String idbFile, String idaDirectory, IDatabase database) throws ConfigFileException, IdaException, ExporterException {
        CImporterManager.instance().startImporting(database, idbFile);
        try {
            int exitCode = 0;
            do {
                String host = CBinExportImporter.getHost(database.getConfiguration().getHost());
                int port = CBinExportImporter.getPort(database.getConfiguration().getHost());
                String user2 = database.getConfiguration().getUser();
                String password = database.getConfiguration().getPassword();
                String name = database.getConfiguration().getName();
                char c2 = File.separatorChar;
                String string2 = String.valueOf(idbFile.endsWith("idb") ? IdaHelpers.IDA32_EXECUTABLE : IdaHelpers.IDA64_EXECUTABLE);
                Process processInfo = CBinExportImporter.createIdaProcess(new StringBuilder(1 + String.valueOf(idaDirectory).length() + String.valueOf(string2).length()).append(idaDirectory).append(c2).append(string2).toString(), idbFile, host, port, user2, password, name);
                try {
                    exitCode = processInfo.waitFor();
                    CBinExportImporter.handleExitCode(exitCode);
                }
                catch (InterruptedException e2) {
                    CUtilityFunctions.logException(e2);
                    Thread.currentThread().interrupt();
                }
            } while ((exitCode & 0xFE) == 254);
        }
        finally {
            CImporterManager.instance().finishImporting(database, idbFile);
        }
    }
}

