/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Help;

import com.google.security.zynamics.binnavi.CMain;
import com.google.security.zynamics.binnavi.Help.CHelpDialog;
import com.google.security.zynamics.binnavi.Help.IHelpInformation;
import com.google.security.zynamics.binnavi.Help.IHelpProvider;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public final class CHelpManager {
    private final CHelpDialog m_helpDialog = new CHelpDialog();
    private final Cursor m_helpCursor;
    private static CHelpManager m_instance = new CHelpManager();
    private Window m_activeWindow = null;
    private final MouseAdapter m_listener = new MouseAdapter(){};

    private CHelpManager() {
        Image cursorImage = Toolkit.getDefaultToolkit().getImage(CMain.class.getResource("data/help.png"));
        Point cursorHotSpot = new Point(0, 0);
        this.m_helpCursor = Toolkit.getDefaultToolkit().createCustomCursor(cursorImage, cursorHotSpot, "helpCursor");
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                CHelpManager.this.handleEvent(event);
            }
        }, 16L);
    }

    public static CHelpManager instance() {
        return m_instance;
    }

    private Point getDialogLocation(MouseEvent event) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension scrnsize = toolkit.getScreenSize();
        int x2 = event.getXOnScreen();
        int y2 = event.getYOnScreen();
        return new Point(this.normalize(x2, this.m_helpDialog.getWidth(), scrnsize.width), this.normalize(y2, this.m_helpDialog.getHeight(), scrnsize.height));
    }

    private void handleEvent(AWTEvent event) {
        Window window;
        MouseEvent kevent = (MouseEvent)event;
        if (kevent.getID() == 500 && SwingUtilities.isLeftMouseButton(kevent)) {
            Window window2 = SwingUtilities.getWindowAncestor(kevent.getComponent());
            if (this.m_activeWindow == window2) {
                JFrame frame = (JFrame)window2;
                frame.getGlassPane().setVisible(false);
                Component component = GuiHelper.findComponentAt(frame, kevent.getLocationOnScreen());
                frame.getGlassPane().setVisible(true);
                if (component instanceof IHelpProvider) {
                    IHelpProvider helpProvider = (IHelpProvider)((Object)component);
                    IHelpInformation help = helpProvider.getHelpInformation();
                    this.m_helpDialog.setInformation(help);
                    this.m_helpDialog.setLocation(this.getDialogLocation(kevent));
                    this.m_helpDialog.setVisible(true);
                }
            }
        } else if (kevent.getID() == 500 && SwingUtilities.isRightMouseButton(kevent) && this.m_activeWindow == (window = SwingUtilities.getWindowAncestor(kevent.getComponent()))) {
            ((JFrame)window).getGlassPane().setVisible(false);
            ((JFrame)window).getGlassPane().removeMouseListener(this.m_listener);
            window.setCursor(Cursor.getDefaultCursor());
            this.m_activeWindow = null;
        }
    }

    private int normalize(int coordinate, int dialogSize, int maximum) {
        if (coordinate + dialogSize > maximum) {
            return maximum - dialogSize - 10;
        }
        return coordinate;
    }

    public void start(JFrame window) {
        if (this.m_activeWindow != window) {
            window.getGlassPane().setVisible(true);
            window.getGlassPane().addMouseListener(this.m_listener);
            window.setCursor(this.m_helpCursor);
            this.m_activeWindow = window;
        }
    }
}

