/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.plugins.output;

import com.google.security.zynamics.binnavi.Gui.plugins.output.CopyLogAction;
import com.google.security.zynamics.binnavi.Gui.plugins.output.implementations.CLogConsoleFunctions;
import com.google.security.zynamics.zylib.gui.CDialogEscaper;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public final class CPluginOutputDialog
extends JDialog {
    private static final long serialVersionUID = -313664677958811619L;
    private static CPluginOutputDialog m_instance = new CPluginOutputDialog();
    private final JTextArea m_textArea = new JTextArea();

    private CPluginOutputDialog() {
        super((Frame)null, "Global Plugin Log");
        new CDialogEscaper(this);
        this.setLayout(new BorderLayout());
        this.m_textArea.setEditable(false);
        this.m_textArea.setFont(GuiHelper.MONOSPACED_FONT);
        this.add(new JScrollPane(this.m_textArea));
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.add((Component)new JButton(new ClearAction()), "West");
        bottomPanel.add((Component)new JButton(new CloseAction()), "East");
        this.add((Component)bottomPanel, "South");
        this.setAlwaysOnTop(true);
        this.setJMenuBar(new CLogConsoleMenuBar());
        this.m_textArea.addMouseListener(new InternalMouseListener());
        this.setSize(600, 400);
    }

    public static CPluginOutputDialog instance() {
        return m_instance;
    }

    public void clear() {
        this.m_textArea.setText("");
    }

    public void log(String message2) {
        this.m_textArea.append(message2);
        this.m_textArea.setCaretPosition(this.m_textArea.getText().length());
    }

    public void showDialog() {
        this.setVisible(true);
        this.toFront();
    }

    private class InternalMouseListener
    extends MouseAdapter {
        private InternalMouseListener() {
        }

        private void maybeShowPopup(MouseEvent event) {
            if (event.isPopupTrigger()) {
                JPopupMenu menu = new JPopupMenu();
                menu.add(new CopyLogAction(CPluginOutputDialog.this.m_textArea));
                menu.show(event.getComponent(), event.getX(), event.getY());
            }
        }

        @Override
        public void mousePressed(MouseEvent event) {
            this.maybeShowPopup(event);
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            this.maybeShowPopup(event);
        }
    }

    private class CSaveToFileAction
    extends AbstractAction {
        private static final long serialVersionUID = 4433760167850896301L;

        public CSaveToFileAction() {
            super("Save to file");
            this.putValue("MnemonicKey", "SaveLogToFileMnemonic".charAt(0));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            CLogConsoleFunctions.save(CPluginOutputDialog.this, CPluginOutputDialog.this.m_textArea.getText());
        }
    }

    private class CloseAction
    extends AbstractAction {
        private static final long serialVersionUID = -687912619884442777L;

        private CloseAction() {
            super("Close");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            CPluginOutputDialog.this.setVisible(false);
        }
    }

    private class CLogConsoleMenuBar
    extends JMenuBar {
        private static final long serialVersionUID = 1484024003232886495L;

        public CLogConsoleMenuBar() {
            JMenu menu = new JMenu("Log");
            menu.setMnemonic("LogMenuMnemonic".charAt(0));
            menu.add(new JMenuItem(new CSaveToFileAction()));
            this.add(menu);
        }
    }

    private class ClearAction
    extends AbstractAction {
        private static final long serialVersionUID = -7767044892455183230L;

        private ClearAction() {
            super("Clear");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            CPluginOutputDialog.this.m_textArea.setText("");
        }
    }
}

