/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.WindowManager;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphWindow;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.IGraphContainerWindow;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.IGraphPanel;
import com.google.security.zynamics.binnavi.Gui.WindowManager.IWindowManagerListener;
import com.google.security.zynamics.binnavi.Log.NaviLogger;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class CWindowManager
implements Iterable<CGraphWindow> {
    private static CWindowManager m_instance = new CWindowManager();
    private final ListenerProvider<IWindowManagerListener> m_listeners = new ListenerProvider();
    private final List<CGraphWindow> m_graphs = new ArrayList<CGraphWindow>();
    private final InternalWindowListener m_listener = new InternalWindowListener();

    private CWindowManager() {
    }

    public static CWindowManager instance() {
        return m_instance;
    }

    private void unregister(CGraphWindow window) {
        if (!this.m_graphs.remove(window)) {
            throw new IllegalStateException("IE01206: Graph window wasn't registered");
        }
        for (IWindowManagerListener listener : this.m_listeners) {
            try {
                listener.windowClosed(this, window);
            }
            catch (Exception e2) {
                CUtilityFunctions.logException(e2);
                NaviLogger.severe("Internal Error: Listener caused an unknown exception", new Object[0]);
            }
        }
    }

    public void addListener(IWindowManagerListener listener) {
        this.m_listeners.addListener(listener);
    }

    public CGraphWindow getLastWindow() {
        return this.m_graphs.isEmpty() ? null : this.m_graphs.get(this.m_graphs.size() - 1);
    }

    public List<CGraphWindow> getOpenWindows() {
        return new ArrayList<CGraphWindow>(this.m_graphs);
    }

    public boolean isOpen(INaviView view) {
        Preconditions.checkNotNull(view, "IE01297: View argument can not be null");
        for (IGraphContainerWindow iGraphContainerWindow : this.getOpenWindows()) {
            for (IGraphPanel window : iGraphContainerWindow) {
                if (window.getModel().getGraph().getRawView() != view) continue;
                return true;
            }
        }
        return false;
    }

    public void bringViewToFront(INaviView view) {
        for (CGraphWindow graphContainer : this.getOpenWindows()) {
            for (IGraphPanel window : graphContainer) {
                if (window.getModel().getGraph().getRawView() != view) continue;
                graphContainer.activate(window);
                graphContainer.toFront();
                return;
            }
        }
    }

    @Override
    public Iterator<CGraphWindow> iterator() {
        return new ArrayList<CGraphWindow>(this.m_graphs).iterator();
    }

    public void register(CGraphWindow window) {
        Preconditions.checkNotNull(window, "IE02084: Graph window can't be null");
        if (this.m_graphs.contains(window)) {
            throw new IllegalStateException("IE01205: Cannot register graph window twice");
        }
        this.m_graphs.add(window);
        window.addWindowListener(this.m_listener);
        for (IWindowManagerListener listener : this.m_listeners) {
            try {
                listener.windowOpened(this, window);
            }
            catch (Exception e2) {
                CUtilityFunctions.logException(e2);
            }
        }
    }

    public void removeListener(IWindowManagerListener listener) {
        this.m_listeners.removeListener(listener);
    }

    private class InternalWindowListener
    extends WindowAdapter {
        private InternalWindowListener() {
        }

        @Override
        public void windowClosed(WindowEvent event) {
            CGraphWindow window = (CGraphWindow)event.getSource();
            CWindowManager.this.unregister(window);
            window.getFrame().removeWindowListener(this);
        }
    }
}

