/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Users;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProviderListener;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.Gui.Users.Interfaces.IUser;
import com.google.security.zynamics.binnavi.Gui.Users.Interfaces.IUserManagerListener;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CUserManager {
    private static Map<SQLProvider, CUserManager> managers = new HashMap<SQLProvider, CUserManager>();
    private final ListenerProvider<IUserManagerListener> listeners = new ListenerProvider();
    private final Set<IUser> users = new HashSet<IUser>();
    private IUser activeUser = null;
    private final SQLProvider provider;
    private final SQLProviderListener providerListener = new InternalSQLProviderListener();

    private CUserManager(SQLProvider provider, List<IUser> users) {
        this.provider = Preconditions.checkNotNull(provider, "IE02716: provider argument can not be null.");
        this.users.addAll(users);
        this.provider.addListener(this.providerListener);
    }

    public static synchronized CUserManager get(SQLProvider provider) {
        Preconditions.checkNotNull(provider, "IE02717: provider argument can not be null.");
        if (!managers.containsKey(provider)) {
            try {
                managers.put(provider, new CUserManager(provider, provider.loadUsers()));
            }
            catch (CouldntLoadDataException exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        return managers.get(provider);
    }

    private void close() {
        managers.remove(this.provider);
        this.provider.removeListener(this.providerListener);
    }

    private synchronized void syncUsers() {
        try {
            this.users.clear();
            this.users.addAll(this.provider.loadUsers());
        }
        catch (CouldntLoadDataException exception) {
            CUtilityFunctions.logException(exception);
        }
    }

    public synchronized void addListener(IUserManagerListener listener) {
        this.listeners.addListener(listener);
    }

    public synchronized IUser addUser(String userName) throws CouldntSaveDataException {
        Preconditions.checkNotNull(userName, "IE02718: user name argument can not be null.");
        if (this.containsUserName(userName)) {
            throw new IllegalStateException("IE02719: User is already known to user management.");
        }
        IUser user2 = this.provider.addUser(userName);
        this.users.add(user2);
        for (IUserManagerListener listener : this.listeners) {
            try {
                listener.addedUser(user2);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        return user2;
    }

    public synchronized boolean containsUserName(String userName) {
        Preconditions.checkNotNull(userName, "IE02720: userName argument can not be null");
        this.syncUsers();
        for (IUser storedUser : this.users) {
            if (!storedUser.getUserName().equalsIgnoreCase(userName)) continue;
            return true;
        }
        return false;
    }

    public synchronized void deleteUser(IUser user2) throws CouldntDeleteException {
        Preconditions.checkNotNull(user2, "IE02721: user argument can not be null");
        if (!this.users.contains(user2)) {
            throw new IllegalStateException("IE02722: User is not known to the user management.");
        }
        this.provider.deleteUser(user2);
        for (IUserManagerListener listener : this.listeners) {
            try {
                listener.deletedUser(user2);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public synchronized IUser editUserName(IUser user2, String userName) throws CouldntSaveDataException {
        Preconditions.checkNotNull(user2, "IE02723: user argument can not be null");
        Preconditions.checkNotNull(userName, "IE02724: userName argument can not be null");
        if (!this.users.contains(user2)) {
            throw new IllegalStateException("IE02725: User is not known to the user management.");
        }
        if (this.containsUserName(userName)) {
            throw new IllegalStateException("IE02726: User name is already in use by another user.");
        }
        IUser newUser = this.provider.editUserName(user2, userName);
        for (IUserManagerListener listener : this.listeners) {
            try {
                listener.editedUser(newUser);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        return newUser;
    }

    public synchronized IUser getCurrentActiveUser() {
        if (this.activeUser == null) {
            throw new IllegalStateException("IE02727: Current active user is not set.");
        }
        return this.activeUser;
    }

    public synchronized Iterator<IUserManagerListener> getListeners() {
        return this.listeners.iterator();
    }

    public synchronized IUser getUserById(int userId) {
        Preconditions.checkArgument(userId >= 0, "Error: User id must be a positive number");
        for (IUser storedUser : this.users) {
            if (storedUser.getUserId() != userId) continue;
            return storedUser;
        }
        this.syncUsers();
        for (IUser storedUser : this.users) {
            if (storedUser.getUserId() != userId) continue;
            return storedUser;
        }
        return null;
    }

    public synchronized IUser getUserByUserName(String userName) {
        Preconditions.checkNotNull(userName, "IE02728: userName argument can not be null");
        for (IUser storedUser : this.users) {
            if (!storedUser.getUserName().equalsIgnoreCase(userName)) continue;
            return storedUser;
        }
        this.syncUsers();
        for (IUser storedUser : this.users) {
            if (!storedUser.getUserName().equalsIgnoreCase(userName)) continue;
            return storedUser;
        }
        return null;
    }

    public synchronized boolean isOwner(IComment comment) {
        return this.getCurrentActiveUser().getUserId() == comment.getUser().getUserId();
    }

    public synchronized void removeListener(IUserManagerListener listener) {
        this.listeners.removeListener(listener);
    }

    public synchronized void setCurrentActiveUser(IUser user2) {
        Preconditions.checkNotNull(user2, "IE02729: user argument can not be null.");
        if (!this.users.contains(user2)) {
            throw new IllegalStateException("Error: User to be set active is not known to user management.");
        }
        this.activeUser = user2;
    }

    private class InternalSQLProviderListener
    implements SQLProviderListener {
        private InternalSQLProviderListener() {
        }

        @Override
        public void providerClosing(SQLProvider provider) {
            if (CUserManager.this.provider.equals(provider)) {
                CUserManager.this.close();
            }
        }
    }
}

