/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Tutorials;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Tutorials.CTutorial;
import com.google.security.zynamics.zylib.gui.CDialogEscaper;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public final class CTutorialStartDialog
extends JDialog {
    private CTutorial selectedTutorial;
    private final JList<CTutorial> tutorialList;
    private final JTextPane tutorialDescription = new JTextPane();

    public CTutorialStartDialog(JFrame owner, List<CTutorial> tutorials) {
        super(owner, "Tutorial Selection", true);
        Preconditions.checkNotNull(owner, "IE02080: Owner argument can not be null");
        Preconditions.checkNotNull(tutorials, "IE02081: Tutorials argument can not be null");
        new CDialogEscaper(this);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(new TitledBorder("Please select the tutorial you want to run"));
        this.tutorialList = new JList<CTutorial>(tutorials.toArray(new CTutorial[tutorials.size()]));
        this.tutorialList.addListSelectionListener(new InternalSelectionListener());
        this.tutorialDescription.setBorder(new TitledBorder(""));
        this.tutorialDescription.setContentType("text/html");
        this.tutorialDescription.setEditable(false);
        if (!tutorials.isEmpty()) {
            this.tutorialList.setSelectedIndex(0);
        }
        JSplitPane splitPane = new JSplitPane(1, new JScrollPane(this.tutorialList), new JScrollPane(this.tutorialDescription));
        splitPane.setDividerLocation(200);
        panel.add(splitPane);
        JPanel bottomPanel = new JPanel(new BorderLayout());
        JPanel buttonPanel = new JPanel();
        JButton closeButton = new JButton(new CancelAction());
        JButton startButton = new JButton(new StartAction());
        buttonPanel.add(closeButton);
        buttonPanel.add(startButton);
        bottomPanel.add((Component)buttonPanel, "East");
        this.add(panel);
        this.add((Component)bottomPanel, "South");
        this.setSize(new Dimension(600, 400));
        GuiHelper.centerChildToParent(owner, this, true);
    }

    public CTutorial getSelectedTutorial() {
        return this.selectedTutorial;
    }

    private class StartAction
    extends AbstractAction {
        private static final long serialVersionUID = 5537321482800475692L;

        private StartAction() {
            super("Start");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            CTutorialStartDialog.this.selectedTutorial = (CTutorial)CTutorialStartDialog.this.tutorialList.getSelectedValue();
            CTutorialStartDialog.this.dispose();
        }
    }

    private class InternalSelectionListener
    implements ListSelectionListener {
        private InternalSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            CTutorial selectedTutorial = (CTutorial)CTutorialStartDialog.this.tutorialList.getSelectedValue();
            if (selectedTutorial != null) {
                CTutorialStartDialog.this.tutorialDescription.setText(selectedTutorial.getDescription());
            }
        }
    }

    private class CancelAction
    extends AbstractAction {
        private static final long serialVersionUID = 4681649702002708880L;

        private CancelAction() {
            super("Cancel");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            CTutorialStartDialog.this.dispose();
        }
    }
}

