/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.SettingsDialog;

import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Gui.SettingsDialog.CAbstractSettingsPanel;
import com.google.security.zynamics.binnavi.Gui.SettingsDialog.CActionProvider;
import com.google.security.zynamics.binnavi.Gui.SettingsDialog.CHintCreator;
import com.google.security.zynamics.binnavi.Gui.SettingsDialog.CLogFilePanel;
import com.google.security.zynamics.binnavi.Log.NaviLogger;
import com.google.security.zynamics.binnavi.config.ConfigManager;
import com.google.security.zynamics.binnavi.config.GeneralSettingsConfigItem;
import com.google.security.zynamics.zylib.gui.FileChooser.FileChooserPanel;
import com.google.security.zynamics.zylib.gui.scripting.LanguageBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import javax.script.ScriptEngineManager;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public final class CGeneralSettingsPanel
extends CAbstractSettingsPanel {
    private static final int TEXTFIELD_WIDTH = 280;
    private static final int TEXTFIELD_HEIGHT = 25;
    private final JTextField emailBox = new JTextField();
    private final FileChooserPanel idaDirectoryPanel = new FileChooserPanel(ConfigManager.instance().getGeneralSettings().getIdaDirectory(), new InternalIDAListener(), "...", 280, 25, 0);
    private final JComboBox<String> logLevelBox = new JComboBox<String>(new String[]{"Off", "On", "Verbose"});
    private final LanguageBox scriptingBox;

    public CGeneralSettingsPanel() {
        super(new BorderLayout());
        this.logLevelBox.setPreferredSize(new Dimension(280, 25));
        ScriptEngineManager manager = new ScriptEngineManager();
        this.scriptingBox = new LanguageBox(manager);
        this.scriptingBox.setPreferredSize(new Dimension(280, 25));
        JPanel pMain = new JPanel(new BorderLayout());
        pMain.add((Component)this.createEditElementsPanel(), "North");
        this.emailBox.setPreferredSize(new Dimension(280, 25));
        this.add(pMain);
    }

    private JPanel createEditElementsPanel() {
        JPanel pEdits = new JPanel(new GridLayout(6, 1, 4, 4));
        pEdits.setBorder(new TitledBorder("General Settings"));
        JPanel idaLocationPanel = new JPanel(new BorderLayout());
        idaLocationPanel.setBorder(new EmptyBorder(0, 2, 0, 2));
        JLabel idaLabel = new JLabel("IDA Pro Installation Directory:");
        idaLabel.setBorder(new EmptyBorder(0, 0, 0, 10));
        idaLocationPanel.add((Component)idaLabel, "Center");
        idaLocationPanel.add(CHintCreator.createHintPanel(this.idaDirectoryPanel, "The location of your IDA installation."), "East");
        pEdits.add(idaLocationPanel);
        JPanel emailBoxPanel = new JPanel(new BorderLayout());
        emailBoxPanel.setBorder(new EmptyBorder(0, 2, 2, 2));
        JLabel emailLabel = new JLabel("Your email address:");
        emailBoxPanel.add((Component)emailLabel, "Center");
        emailBoxPanel.add(CHintCreator.createHintPanel(this.emailBox, "This email address is used to contact you after you have submitted bugs."), "East");
        pEdits.add((Component)emailBoxPanel, "Center");
        this.emailBox.setText(ConfigManager.instance().getGeneralSettings().getSupportEmailAddress());
        JPanel scriptingPanel = new JPanel(new BorderLayout());
        scriptingPanel.setBorder(new EmptyBorder(0, 2, 2, 2));
        JLabel scriptingLabel = new JLabel("Default Scripting Language:");
        scriptingPanel.add((Component)scriptingLabel, "Center");
        scriptingPanel.add(CHintCreator.createHintPanel(this.scriptingBox, "Scripting language that is selected by default when opening scripting dialogs."), "East");
        pEdits.add((Component)scriptingPanel, "Center");
        this.scriptingBox.setSelectedLanguage(ConfigManager.instance().getGeneralSettings().getDefaultScriptingLanguage());
        JPanel logLevelPanel = new JPanel(new BorderLayout());
        logLevelPanel.setBorder(new EmptyBorder(0, 2, 2, 2));
        JLabel logLevelLabel = new JLabel("Log Level:");
        logLevelPanel.add((Component)logLevelLabel, "Center");
        logLevelPanel.add(CHintCreator.createHintPanel(this.logLevelBox, "Determines what messages are logged to the log file."), "East");
        pEdits.add((Component)logLevelPanel, "Center");
        this.logLevelBox.setSelectedIndex(ConfigManager.instance().getGeneralSettings().getLogLevel());
        JPanel logFilePanel = new JPanel(new BorderLayout());
        logFilePanel.setBorder(new EmptyBorder(0, 2, 2, 2));
        JLabel logFileLabel = new JLabel("Log File:");
        CLogFilePanel fileLabel = new CLogFilePanel();
        fileLabel.setPreferredSize(new Dimension(280, 25));
        logFilePanel.add((Component)logFileLabel, "Center");
        logFilePanel.add(CHintCreator.createHintPanel(fileLabel, "Location of the BinNavi log file."), "East");
        pEdits.add((Component)logFilePanel, "Center");
        return pEdits;
    }

    @Override
    protected boolean save() {
        GeneralSettingsConfigItem settings = ConfigManager.instance().getGeneralSettings();
        settings.setIdaDirectory(this.idaDirectoryPanel.getText());
        settings.setLogLevel(this.logLevelBox.getSelectedIndex());
        settings.setDefaultScriptingLanguage(this.scriptingBox.getSelectedLanguage());
        settings.setSupportEmailAddress(this.emailBox.getText());
        switch (this.logLevelBox.getSelectedIndex()) {
            case 0: {
                NaviLogger.setLevel(Level.OFF);
                break;
            }
            case 1: {
                NaviLogger.setLevel(Level.INFO);
                break;
            }
            case 2: {
                NaviLogger.setLevel(Level.ALL);
                break;
            }
            default: {
                throw new IllegalStateException("IE01190: Invalid log level selection");
            }
        }
        return false;
    }

    private class InternalIDAListener
    implements ActionListener {
        private InternalIDAListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                String idaPath = CActionProvider.selectIDADirectory(CGeneralSettingsPanel.this, CGeneralSettingsPanel.this.idaDirectoryPanel.getText());
                if (idaPath != null) {
                    CGeneralSettingsPanel.this.idaDirectoryPanel.setText(idaPath);
                }
            }
            catch (Exception e2) {
                CUtilityFunctions.logException(e2);
            }
        }
    }
}

