/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.SettingsDialog;

import com.google.security.zynamics.binnavi.Gui.SettingsDialog.CAbstractSettingsPanel;
import com.google.security.zynamics.binnavi.Gui.SettingsDialog.CHintCreator;
import com.google.security.zynamics.binnavi.config.ColorsConfigItem;
import com.google.security.zynamics.binnavi.config.ConfigManager;
import com.google.security.zynamics.binnavi.config.DebugColorsConfigItem;
import com.google.security.zynamics.zylib.gui.ColorPanel.ColorPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public final class CColorSettingsPanel
extends CAbstractSettingsPanel {
    private static final int COLORPANEL_WIDTH = 200;
    private static final int COLORPANEL_HEIGHT = 25;
    private final ColorPanel m_normalFunctionColorPanel;
    private final ColorPanel m_importFunctionColorPanel;
    private final ColorPanel m_libraryFunctionColorPanel;
    private final ColorPanel m_thunkFunctionColorPanel;
    private final ColorPanel m_adjustorThunkFunctionColorPanel;
    private final ColorPanel m_addressColorPanel;
    private final ColorPanel m_mnemonicColorPanel;
    private final ColorPanel m_literalsColorPanel;
    private final ColorPanel m_registersColorPanel;
    private final ColorPanel m_functionColorPanel;
    private final ColorPanel m_variableColorPanel;
    private final ColorPanel m_expressionListColorPanel;
    private final ColorPanel m_memoryReferencesColorPanel;
    private final ColorPanel m_operatorColorPanel;
    private final ColorPanel m_operandSeparatorColorPanel;
    private final ColorPanel m_prefixColorPanel;
    private final ColorPanel m_basicblocksPanel;
    private final ColorPanel m_unconditionalJumpsPanel;
    private final ColorPanel m_conditionalJumpsTakenPanel;
    private final ColorPanel m_conditionalJumpsNotTakenPanel;
    private final ColorPanel m_enterInlinedJumpsPanel;
    private final ColorPanel m_leaveInlinedJumpsPanel;
    private final ColorPanel m_switchPanel;
    private final ColorPanel m_textJumpsPanel;
    private final ColorPanel m_activeLineColorPanel;
    private final ColorPanel m_activeBreakpointColorPanel;
    private final ColorPanel m_inactiveBreakpointColorPanel;
    private final ColorPanel m_enabledBreakpointColorPanel;
    private final ColorPanel m_disabledBreakpointColorPanel;
    private final ColorPanel m_invalidBreakpointColorPanel;
    private final ColorPanel m_deletingBreakpointColorPanel;
    private final ColorPanel m_hitBreakpointColorPanel;

    public CColorSettingsPanel() {
        super(new BorderLayout());
        JPanel mainPanel = new JPanel(new BorderLayout());
        JPanel innerMainPanel = new JPanel(new GridBagLayout());
        JPanel functionTypeColorPanel = new JPanel(new GridLayout(5, 1, 3, 3));
        ColorsConfigItem colors2 = ConfigManager.instance().getColorSettings();
        this.m_normalFunctionColorPanel = CColorSettingsPanel.buildRow(functionTypeColorPanel, "Normal Function:", "Color used to paint normal functions in callgraphs and view tables", new ColorPanel(colors2.getNormalFunctionColor(), true, true), false);
        this.m_importFunctionColorPanel = CColorSettingsPanel.buildRow(functionTypeColorPanel, "Imported Function:", "Color used to paint imported functions in callgraphs and view tables", new ColorPanel(colors2.getImportedFunctionColor(), true, true), false);
        this.m_libraryFunctionColorPanel = CColorSettingsPanel.buildRow(functionTypeColorPanel, "Library Function:", "Color used to paint library functions in callgraphs and view tables", new ColorPanel(colors2.getLibraryFunctionColor(), true, true), false);
        this.m_thunkFunctionColorPanel = CColorSettingsPanel.buildRow(functionTypeColorPanel, "Thunk Function:", "Color used to paint thunk functions in callgraphs and view tables", new ColorPanel(colors2.getThunkFunctionColor(), true, true), false);
        this.m_adjustorThunkFunctionColorPanel = CColorSettingsPanel.buildRow(functionTypeColorPanel, "Unknown Function:", "Color used to paint thunk adjustor functions in callgraphs and view tables", new ColorPanel(colors2.getAdjustorThunkFunctionColor(), true, true), true);
        functionTypeColorPanel.setBorder(new TitledBorder("Function Colors"));
        JPanel instructionColorPanel = new JPanel(new GridLayout(11, 1, 3, 3));
        instructionColorPanel.setBorder(new TitledBorder("Instruction Colors"));
        this.m_addressColorPanel = CColorSettingsPanel.buildRow(instructionColorPanel, "Addresses:", "Color used to paint addresses in graphs", new ColorPanel(colors2.getAddressColor(), true, true), false);
        this.m_mnemonicColorPanel = CColorSettingsPanel.buildRow(instructionColorPanel, "Mnemonics:", "Color used to paint mnemonics in graphs", new ColorPanel(colors2.getMnemonicColor(), true, true), false);
        this.m_literalsColorPanel = CColorSettingsPanel.buildRow(instructionColorPanel, "Immediates:", "Color used to paint immediate values in graphs", new ColorPanel(colors2.getImmediateColor(), true, true), false);
        this.m_registersColorPanel = CColorSettingsPanel.buildRow(instructionColorPanel, "Registers:", "Color used to paint registers in graphs", new ColorPanel(colors2.getRegisterColor(), true, true), false);
        this.m_functionColorPanel = CColorSettingsPanel.buildRow(instructionColorPanel, "Functions:", "Color used to paint function references in graphs", new ColorPanel(colors2.getFunctionColor(), true, true), false);
        this.m_variableColorPanel = CColorSettingsPanel.buildRow(instructionColorPanel, "Variables:", "Color used to paint variables in graphs", new ColorPanel(colors2.getVariableColor(), true, true), false);
        this.m_expressionListColorPanel = CColorSettingsPanel.buildRow(instructionColorPanel, "Expression List:", "Color used to paint expression lists in graphs", new ColorPanel(colors2.getExpressionListColor(), true, true), false);
        this.m_memoryReferencesColorPanel = CColorSettingsPanel.buildRow(instructionColorPanel, "Memory References:", "Color used to paint memory references in graphs", new ColorPanel(colors2.getMemRefColor(), true, true), false);
        this.m_operatorColorPanel = CColorSettingsPanel.buildRow(instructionColorPanel, "Operators:", "Color used to paint operators in graphs", new ColorPanel(colors2.getOperatorColor(), true, true), false);
        this.m_operandSeparatorColorPanel = CColorSettingsPanel.buildRow(instructionColorPanel, "Operand Separators:", "Color used to paint operand separators in graphs", new ColorPanel(colors2.getOperandSeparatorColor(), true, true), false);
        this.m_prefixColorPanel = CColorSettingsPanel.buildRow(instructionColorPanel, "Prefixes:", "Color used to paint prefixes in graphs", new ColorPanel(colors2.getPrefixColor(), true, true), true);
        JPanel graphColorPanel = new JPanel(new GridLayout(8, 1, 3, 3));
        graphColorPanel.setBorder(new TitledBorder("Graph Colors"));
        this.m_basicblocksPanel = CColorSettingsPanel.buildRow(graphColorPanel, "Basic Blocks:", "Color used to paint basic blocks in graphs", new ColorPanel(colors2.getBasicBlocksColor(), true, true), false);
        this.m_unconditionalJumpsPanel = CColorSettingsPanel.buildRow(graphColorPanel, "Unconditional Jumps:", "Color of unconditional jumps", new ColorPanel(colors2.getUnconditionalJumpColor(), true, true), false);
        this.m_conditionalJumpsTakenPanel = CColorSettingsPanel.buildRow(graphColorPanel, "Conditional Jumps (Taken):", "Color of conditional jumps which are taken", new ColorPanel(colors2.getConditionalJumpTrueColor(), true, true), false);
        this.m_conditionalJumpsNotTakenPanel = CColorSettingsPanel.buildRow(graphColorPanel, "Conditional Jumps (Not taken):", "Color of conditional jumps which are not taken", new ColorPanel(colors2.getConditionalJumpFalseColor(), true, true), false);
        this.m_enterInlinedJumpsPanel = CColorSettingsPanel.buildRow(graphColorPanel, "Entering inlined functions:", "Color of edges used to enter inlined functions", new ColorPanel(colors2.getEnterInlinedJumpColor(), true, true), false);
        this.m_leaveInlinedJumpsPanel = CColorSettingsPanel.buildRow(graphColorPanel, "Leaving inlined functions:", "Color of edges used to leave inlined functions", new ColorPanel(colors2.getLeaveInlinedJumpColor(), true, true), true);
        this.m_switchPanel = CColorSettingsPanel.buildRow(graphColorPanel, "Switches:", "Color of edges that belong to switch statements", new ColorPanel(colors2.getSwitchJumpColor(), true, true), true);
        this.m_textJumpsPanel = CColorSettingsPanel.buildRow(graphColorPanel, "Edges to comment nodes:", "Color of edges that connect comment nodes to other nodes", new ColorPanel(colors2.getTextEdgeColor(), true, true), true);
        JPanel debuggerColorPanel = new JPanel(new GridLayout(8, 1, 3, 3));
        DebugColorsConfigItem debuggerColors = ConfigManager.instance().getDebuggerColorSettings();
        this.m_activeLineColorPanel = CColorSettingsPanel.buildRow(debuggerColorPanel, "Active Line:", "Color used to show the line at the program counter while debugging.", new ColorPanel(debuggerColors.getActiveLine(), true, true), false);
        this.m_activeBreakpointColorPanel = CColorSettingsPanel.buildRow(debuggerColorPanel, "Active Breakpoint:", "Color used to show active breakpoints while debugging.", new ColorPanel(debuggerColors.getBreakpointActive(), true, true), false);
        this.m_inactiveBreakpointColorPanel = CColorSettingsPanel.buildRow(debuggerColorPanel, "Inactive Breakpoint:", "Color used to show inactive breakpoints while debugging.", new ColorPanel(debuggerColors.getBreakpointInactive(), true, true), false);
        this.m_enabledBreakpointColorPanel = CColorSettingsPanel.buildRow(debuggerColorPanel, "Enabled Breakpoint:", "Color used to show enabled breakpoints while debugging.", new ColorPanel(debuggerColors.getBreakpointEnabled(), true, true), false);
        this.m_disabledBreakpointColorPanel = CColorSettingsPanel.buildRow(debuggerColorPanel, "Disabled Breakpoint:", "Color used to show disabled breakpoints while debugging.", new ColorPanel(debuggerColors.getBreakpointDisabled(), true, true), false);
        this.m_hitBreakpointColorPanel = CColorSettingsPanel.buildRow(debuggerColorPanel, "Hit Breakpoint:", "Color used to show hit breakpoints while debugging.", new ColorPanel(debuggerColors.getBreakpointHit(), true, true), false);
        this.m_invalidBreakpointColorPanel = CColorSettingsPanel.buildRow(debuggerColorPanel, "Invalid Breakpoint:", "Color used to show invalid breakpoints while debugging.", new ColorPanel(debuggerColors.getBreakpointInvalid(), true, true), false);
        this.m_deletingBreakpointColorPanel = CColorSettingsPanel.buildRow(debuggerColorPanel, "Deleting Breakpoint:", "Color used to show deleting breakpoints while debugging.", new ColorPanel(debuggerColors.getBreakpointDeleting(), true, true), true);
        debuggerColorPanel.setBorder(new TitledBorder("Debugger Colors"));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 23;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        innerMainPanel.add((Component)functionTypeColorPanel, constraints);
        constraints.gridy = 1;
        innerMainPanel.add((Component)instructionColorPanel, constraints);
        constraints.gridy = 2;
        innerMainPanel.add((Component)graphColorPanel, constraints);
        constraints.gridy = 3;
        innerMainPanel.add((Component)debuggerColorPanel, constraints);
        mainPanel.add((Component)innerMainPanel, "North");
        this.add(new JScrollPane(mainPanel));
    }

    private static <T extends Component> T buildRow(JPanel panel, String labelText, String hint, T component, boolean isLast) {
        component.setPreferredSize(new Dimension(200, 25));
        JPanel rowPanel = new JPanel(new BorderLayout());
        rowPanel.setBorder(new EmptyBorder(0, 2, isLast ? 2 : 0, 2));
        rowPanel.add((Component)new JLabel(labelText), "Center");
        rowPanel.add(CHintCreator.createHintPanel(component, hint), "East");
        panel.add(rowPanel);
        return component;
    }

    @Override
    protected boolean save() {
        ColorsConfigItem colors2 = ConfigManager.instance().getColorSettings();
        colors2.setNormalFunctionColor(this.m_normalFunctionColorPanel.getColor());
        colors2.setImportedFunctionColor(this.m_importFunctionColorPanel.getColor());
        colors2.setLibraryFunctionColor(this.m_libraryFunctionColorPanel.getColor());
        colors2.setThunkFunctionColor(this.m_thunkFunctionColorPanel.getColor());
        colors2.setAdjustorThunkFunctionColor(this.m_adjustorThunkFunctionColorPanel.getColor());
        colors2.setAddressColor(this.m_addressColorPanel.getColor());
        colors2.setMnemonicColor(this.m_mnemonicColorPanel.getColor());
        colors2.setImmediateColor(this.m_literalsColorPanel.getColor());
        colors2.setRegisterColor(this.m_registersColorPanel.getColor());
        colors2.setFunctionColor(this.m_functionColorPanel.getColor());
        colors2.setVariableColor(this.m_variableColorPanel.getColor());
        colors2.setExpressionListColor(this.m_expressionListColorPanel.getColor());
        colors2.setMemRefColor(this.m_memoryReferencesColorPanel.getColor());
        colors2.setOperatorColor(this.m_operatorColorPanel.getColor());
        colors2.setOperandSeperatorColor(this.m_operandSeparatorColorPanel.getColor());
        colors2.setPrefixColor(this.m_prefixColorPanel.getColor());
        colors2.setAddressColor(this.m_addressColorPanel.getColor());
        colors2.setBasicBlocksColor(this.m_basicblocksPanel.getColor());
        colors2.setUnconditionalJumpColor(this.m_unconditionalJumpsPanel.getColor());
        colors2.setConditionalJumpTrueColor(this.m_conditionalJumpsTakenPanel.getColor());
        colors2.setConditionalJumpFalseColor(this.m_conditionalJumpsNotTakenPanel.getColor());
        colors2.setEnterInlinedJumpColor(this.m_enterInlinedJumpsPanel.getColor());
        colors2.setLeaveInlinedJumpColor(this.m_leaveInlinedJumpsPanel.getColor());
        colors2.setSwitchJumpColor(this.m_switchPanel.getColor());
        colors2.setTextEdgeColor(this.m_textJumpsPanel.getColor());
        DebugColorsConfigItem debuggerColors = ConfigManager.instance().getDebuggerColorSettings();
        debuggerColors.setActiveLine(this.m_activeLineColorPanel.getColor());
        debuggerColors.setBreakpointActive(this.m_activeBreakpointColorPanel.getColor());
        debuggerColors.setBreakpointInactive(this.m_inactiveBreakpointColorPanel.getColor());
        debuggerColors.setBreakpointEnabled(this.m_enabledBreakpointColorPanel.getColor());
        debuggerColors.setBreakpointDisabled(this.m_disabledBreakpointColorPanel.getColor());
        debuggerColors.setBreakpointInvalid(this.m_invalidBreakpointColorPanel.getColor());
        debuggerColors.setBreakpointDeleting(this.m_deletingBreakpointColorPanel.getColor());
        debuggerColors.setBreakpointHit(this.m_hitBreakpointColorPanel.getColor());
        return false;
    }
}

