/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.ReilInstructionDialog;

import com.google.common.collect.Lists;
import com.google.security.zynamics.binnavi.Gui.Actions.CActionProxy;
import com.google.security.zynamics.binnavi.Gui.ReilInstructionDialog.CActionCopyAllReilCode;
import com.google.security.zynamics.binnavi.Gui.ReilInstructionDialog.CReilInstructionDialogMenu;
import com.google.security.zynamics.binnavi.ZyGraph.Implementations.CNodeFunctions;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.reil.ReilBlock;
import com.google.security.zynamics.reil.ReilGraph;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.ReilTranslator;
import com.google.security.zynamics.reil.translators.StandardEnvironment;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import java.awt.BorderLayout;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public final class CReilInstructionDialog
extends JDialog {
    private static final long serialVersionUID = -2412060565212653357L;
    private final JTextArea m_textArea;

    private CReilInstructionDialog(Window parent, String title, String text2) throws InternalTranslationException {
        super(parent, title);
        this.m_textArea = new JTextArea(text2);
        this.m_textArea.setEditable(false);
        this.m_textArea.setFont(GuiHelper.MONOSPACED_FONT);
        this.m_textArea.addMouseListener(new PopupListener());
        this.addMenuBar();
        this.setLayout(new BorderLayout());
        this.add(new JScrollPane(this.m_textArea));
        this.setSize(500, 300);
    }

    private static String reilGraphToText(ReilGraph graph) {
        ArrayList<ReilInstruction> reilInstructions = new ArrayList<ReilInstruction>();
        for (ReilBlock reilBlock : graph.getNodes()) {
            reilInstructions.addAll(Lists.newArrayList(reilBlock.getInstructions()));
        }
        Collections.sort(reilInstructions, new Comparator<ReilInstruction>(){

            @Override
            public int compare(ReilInstruction lhs, ReilInstruction rhs) {
                return (int)(lhs.getAddress().toLong() - rhs.getAddress().toLong());
            }
        });
        StringBuilder buffer = new StringBuilder();
        for (ReilInstruction reilInstruction : reilInstructions) {
            buffer.append(reilInstruction.toString());
            buffer.append('\n');
        }
        return buffer.toString();
    }

    public static void show(Window parent, INaviCodeNode node) throws InternalTranslationException {
        ReilGraph graph = CNodeFunctions.copyReilCode(parent, node);
        String title = String.format("REIL code of %s", node.getAddress().toHexString());
        String text2 = CReilInstructionDialog.reilGraphToText(graph);
        CReilInstructionDialog dialog = new CReilInstructionDialog(parent, title, text2);
        GuiHelper.centerChildToParent(parent, dialog, true);
        dialog.setVisible(true);
    }

    public static void show(Window parent, INaviInstruction instruction) throws InternalTranslationException {
        ReilTranslator<INaviInstruction> translator = new ReilTranslator<INaviInstruction>();
        ReilGraph reilGraph = translator.translate((ITranslationEnvironment)new StandardEnvironment(), instruction);
        String text2 = CReilInstructionDialog.reilGraphToText(reilGraph);
        String title = String.format("REIL code of '%s'", instruction.toString());
        CReilInstructionDialog dialog = new CReilInstructionDialog(parent, title, text2);
        GuiHelper.centerChildToParent(parent, dialog, true);
        dialog.setVisible(true);
    }

    private void addMenuBar() {
        JMenu menu = new JMenu("REIL Code");
        JMenuItem copyItem = new JMenuItem(CActionProxy.proxy(new CActionCopyAllReilCode(this.m_textArea)));
        menu.add(copyItem);
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(menu);
        this.setJMenuBar(menuBar);
    }

    private class PopupListener
    extends MouseAdapter {
        private PopupListener() {
        }

        private void maybeShowPopup(MouseEvent event) {
            if (event.isPopupTrigger()) {
                new CReilInstructionDialogMenu(CReilInstructionDialog.this.m_textArea).show(event.getComponent(), event.getX(), event.getY());
            }
        }

        @Override
        public void mousePressed(MouseEvent event) {
            this.maybeShowPopup(event);
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            this.maybeShowPopup(event);
        }
    }
}

