/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Progress;

import com.google.security.zynamics.binnavi.Gui.Progress.CGlobalProgressDialog;
import com.google.security.zynamics.binnavi.Gui.Progress.CGlobalProgressManager;
import com.google.security.zynamics.binnavi.Gui.Progress.IGlobalProgressManagerListener;
import com.google.security.zynamics.binnavi.Gui.Progress.IProgressOperation;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.CProgressPanel;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class CProgressStatusBar
extends JPanel {
    private final CProgressPanel m_progressPanel = new CProgressPanel(null, true, false, false);
    private final IGlobalProgressManagerListener m_listener = new IGlobalProgressManagerListener(){

        @Override
        public void added(IProgressOperation operation) {
            CProgressStatusBar.this.process();
        }

        @Override
        public void removed(IProgressOperation operation) {
            CProgressStatusBar.this.process();
        }
    };
    private static CGlobalProgressDialog m_dialog = new CGlobalProgressDialog();

    public CProgressStatusBar() {
        this.setLayout(new BorderLayout());
        this.add(this.m_progressPanel);
        this.process();
        this.setPreferredSize(new Dimension(200, 30));
        CGlobalProgressManager.instance().addListener(this.m_listener);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(event)) {
                    CProgressStatusBar.this.getDialog().setVisible(true);
                }
            }
        });
    }

    private CGlobalProgressDialog getDialog() {
        return m_dialog;
    }

    private synchronized void process() {
        this.updateDisplayString();
    }

    private void updateDisplayString() {
        List<IProgressOperation> operations = CGlobalProgressManager.instance().getOperations();
        if (operations.isEmpty()) {
            this.m_progressPanel.setProgressText("");
            this.setVisible(false);
        } else {
            String string2;
            IProgressOperation firstOperation = operations.get(0);
            String string3 = String.valueOf(firstOperation.getDescription());
            if (operations.size() == 1) {
                string2 = "";
            } else {
                int n2 = operations.size() - 1;
                string2 = new StringBuilder(16).append(" ( +").append(n2).append(")").toString();
            }
            String string4 = String.valueOf(string2);
            String displayString = string4.length() != 0 ? string3.concat(string4) : new String(string3);
            this.m_progressPanel.setProgressText(displayString);
            this.setVisible(true);
        }
    }
}

