/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.filters.Views;

import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.filters.Functions.IFilterDialogListener;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class CViewTypePanel
extends JPanel {
    private static final long serialVersionUID = -7710323137862784506L;
    private final JCheckBox m_flowgraphViewsCheckbox = new JCheckBox("", true);
    private final JCheckBox m_callgraphViewsCheckbox = new JCheckBox("", true);
    private final JCheckBox m_mixedViewsCheckbox = new JCheckBox("", true);
    private final InternalCheckboxListener m_checkBoxListener = new InternalCheckboxListener();
    private final ListenerProvider<IFilterDialogListener> m_listeners;

    public CViewTypePanel(ListenerProvider<IFilterDialogListener> listeners) {
        super(new BorderLayout());
        this.m_listeners = listeners;
        JPanel innerPanel = new JPanel(new GridLayout(3, 1));
        innerPanel.add(this.buildRow("Flow graph views", this.m_flowgraphViewsCheckbox));
        innerPanel.add(this.buildRow("Call graph views", this.m_callgraphViewsCheckbox));
        innerPanel.add(this.buildRow("Mixed views", this.m_mixedViewsCheckbox));
        this.add((Component)innerPanel, "North");
        this.setBorder(new TitledBorder("View type"));
    }

    private JPanel buildRow(String string2, JCheckBox checkBox) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JLabel(string2), "West");
        panel.add((Component)checkBox, "East");
        checkBox.addItemListener(this.m_checkBoxListener);
        return panel;
    }

    public boolean isShowCallgraphViews() {
        return this.m_callgraphViewsCheckbox.isSelected();
    }

    public boolean isShowFlowgraphViews() {
        return this.m_flowgraphViewsCheckbox.isSelected();
    }

    public boolean isShowMixedViews() {
        return this.m_mixedViewsCheckbox.isSelected();
    }

    private class InternalCheckboxListener
    implements ItemListener {
        private InternalCheckboxListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent arg0) {
            for (IFilterDialogListener listener : CViewTypePanel.this.m_listeners) {
                try {
                    listener.updated();
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }
    }
}

