/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.filters.Functions;

import com.google.security.zynamics.binnavi.CMain;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.IFilter;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.IFilterComponent;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.IFilterComponentListener;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.filters.Functions.CFunctionFilterDialog;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.filters.Functions.CFunctionTypePanel;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.filters.Functions.IFilterDialogListener;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.disassembly.views.IViewContainer;
import com.google.security.zynamics.zylib.disassembly.FunctionType;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.types.common.CollectionHelpers;
import com.google.security.zynamics.zylib.types.common.ICollectionFilter;
import com.google.security.zynamics.zylib.types.lists.FilledList;
import com.google.security.zynamics.zylib.types.lists.IFilledList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;

public final class CFunctionFilterComponent
extends JPanel
implements IFilterComponent<INaviView> {
    private final IViewContainer module;
    private final CFunctionFilterDialog dialog;
    private final IFilterDialogListener filterDialogListener = new InternalFilterDialogListener();
    private final ListenerProvider<IFilterComponentListener> m_listeners = new ListenerProvider();

    public CFunctionFilterComponent(IViewContainer module) {
        super(new BorderLayout());
        this.module = module;
        if (GraphicsEnvironment.isHeadless()) {
            this.dialog = null;
        } else {
            this.dialog = new CFunctionFilterDialog(module.getDatabase().getContent().getViewTagManager(), module.getDatabase().getContent().getNodeTagManager());
            this.dialog.addListener(this.filterDialogListener);
        }
        this.add(new JButton(new CFilterAction()));
    }

    @Override
    public void addListener(IFilterComponentListener listener) {
        this.m_listeners.addListener(listener);
    }

    @Override
    public IFilter<INaviView> createFilter() {
        return new IFilter<INaviView>(){

            @Override
            public boolean checkCondition(INaviView element) {
                CFunctionTypePanel typePanel = CFunctionFilterComponent.this.dialog.getFunctionTypePanel();
                INaviFunction function = CFunctionFilterComponent.this.module.getFunction(element);
                return typePanel.isShowAdjustorFunctions() && function.getType() == FunctionType.ADJUSTOR_THUNK || typePanel.isShowImportedFunctions() && function.getType() == FunctionType.IMPORT || typePanel.isShowLibraryFunctions() && function.getType() == FunctionType.LIBRARY || typePanel.isShowNormalFunctions() && function.getType() == FunctionType.NORMAL || typePanel.isShowThunkFunctions() && function.getType() == FunctionType.THUNK;
            }

            @Override
            public IFilledList<INaviView> get(List<INaviView> elements) {
                return new FilledList<INaviView>((Collection<INaviView>)CollectionHelpers.filter(elements, new ICollectionFilter<INaviView>(){

                    @Override
                    public boolean qualifies(INaviView item) {
                        return this.checkCondition(item);
                    }
                }));
            }
        };
    }

    public void dispose() {
        if (this.dialog != null) {
            this.dialog.removeListener(this.filterDialogListener);
        }
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void removeListener(IFilterComponentListener listener) {
        this.m_listeners.removeListener(listener);
    }

    private class InternalFilterDialogListener
    implements IFilterDialogListener {
        private InternalFilterDialogListener() {
        }

        @Override
        public void updated() {
            for (IFilterComponentListener listener : CFunctionFilterComponent.this.m_listeners) {
                listener.updated();
            }
        }
    }

    private class CFilterAction
    extends AbstractAction {
        public CFilterAction() {
            super("", new ImageIcon(CMain.class.getResource("data/funnel.png")));
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            int y2 = CFunctionFilterComponent.this.getLocationOnScreen().y - CFunctionFilterComponent.this.dialog.getHeight() + CFunctionFilterComponent.this.getHeight();
            if (y2 < 0) {
                y2 = 0;
            }
            CFunctionFilterComponent.this.dialog.setLocation(CFunctionFilterComponent.this.getLocationOnScreen().x + CFunctionFilterComponent.this.getWidth(), y2);
            CFunctionFilterComponent.this.dialog.setVisible(true);
        }
    }
}

