/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.filters;

import com.google.security.zynamics.binnavi.Gui.FilterPanel.CCombinedFilter;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.CFilterRuleParser;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.FilterExpressions.AbstractTree.CAbstractAndExpression;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.FilterExpressions.AbstractTree.CAbstractOrExpression;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.FilterExpressions.AbstractTree.CPredicateExpression;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.FilterExpressions.AbstractTree.IAbstractNode;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.FilterExpressions.ConcreteTree.CAndExpression;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.FilterExpressions.ConcreteTree.COrExpression;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.FilterExpressions.ConcreteTree.IFilterExpression;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.FilterExpressions.IPredicateGenerator;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.IFilter;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.IFilterComponent;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.IFilterFactory;
import java.util.ArrayList;
import java.util.Collection;
import org.antlr.runtime.RecognitionException;

public abstract class CDefaultFilterCreator<T, WrapperType>
implements IFilterFactory<T> {
    private final Collection<IPredicateGenerator<WrapperType>> m_expressions;

    public CDefaultFilterCreator(Collection<? extends IPredicateGenerator<WrapperType>> expressions) {
        this.m_expressions = new ArrayList<IPredicateGenerator<WrapperType>>(expressions);
    }

    private IFilterExpression<WrapperType> convert(IAbstractNode node) {
        if (node instanceof CPredicateExpression) {
            CPredicateExpression predicate = (CPredicateExpression)node;
            for (IPredicateGenerator<WrapperType> expression : this.m_expressions) {
                if (!expression.canParse(predicate.getText())) continue;
                return expression.createExpression(predicate.getText());
            }
            throw new IllegalStateException();
        }
        if (node instanceof CAbstractAndExpression) {
            CAbstractAndExpression andExpression = (CAbstractAndExpression)node;
            ArrayList children = new ArrayList();
            for (IAbstractNode child : andExpression.getChildren()) {
                children.add(this.convert(child));
            }
            return new CAndExpression(children);
        }
        if (node instanceof CAbstractOrExpression) {
            CAbstractOrExpression orExpression = (CAbstractOrExpression)node;
            ArrayList children = new ArrayList();
            for (IAbstractNode child : orExpression.getChildren()) {
                children.add(this.convert(child));
            }
            return new COrExpression(children);
        }
        throw new IllegalStateException("IE01158: Not yet implemented");
    }

    private boolean validate(IAbstractNode root) {
        if (root instanceof CPredicateExpression) {
            CPredicateExpression predicate = (CPredicateExpression)root;
            for (IPredicateGenerator<WrapperType> expression : this.m_expressions) {
                if (!expression.canParse(predicate.getText())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected abstract IFilter<T> createFilter(IFilterExpression<WrapperType> var1);

    @Override
    public IFilter<T> createFilter(String text2) throws RecognitionException {
        IFilter<T> componentFilter;
        IFilterComponent<T> filterComponent = this.getFilterComponent();
        IFilter<T> iFilter = componentFilter = filterComponent == null ? null : filterComponent.createFilter();
        if ("".equals(text2)) {
            return componentFilter == null ? null : componentFilter;
        }
        IAbstractNode root = CFilterRuleParser.parse(text2);
        if (this.validate(root)) {
            if (componentFilter == null) {
                return this.createFilter(this.convert(root));
            }
            IFilter<T> filter = this.createFilter(this.convert(root));
            return new CCombinedFilter(filter, componentFilter);
        }
        return null;
    }

    @Override
    public void dispose() {
    }

    @Override
    public IFilterComponent<T> getFilterComponent() {
        return null;
    }
}

