/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Views.Project;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CMain;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CAbstractLazyComponent;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CAbstractNodeComponent;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CProjectTreeNode;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Root.CRootNodeMenuBuilder;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Views.Project.Component.CProjectViewsContainerComponent;
import com.google.security.zynamics.binnavi.disassembly.CProjectContainer;
import com.google.security.zynamics.binnavi.disassembly.CProjectListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.INaviProject;
import com.google.security.zynamics.binnavi.disassembly.views.CViewFilter;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;

public final class CProjectViewsContainerNode
extends CProjectTreeNode<INaviProject> {
    private static final long serialVersionUID = 2704981433389804914L;
    private static final ImageIcon ICON_VIEW = new ImageIcon(CMain.class.getResource("data/projecttreeicons/view2.png"));
    private final INaviProject m_project;
    private final InternalProjectListener m_listener = new InternalProjectListener();

    public CProjectViewsContainerNode(final JTree projectTree, final INaviProject project, final CProjectContainer container) {
        super(projectTree, new CAbstractLazyComponent(){

            @Override
            protected CAbstractNodeComponent createComponent() {
                return new CProjectViewsContainerComponent(projectTree, project, container);
            }
        }, new CRootNodeMenuBuilder(projectTree), project);
        Preconditions.checkNotNull(project, "IE02051: Project can't be null");
        this.m_project = project;
        this.m_project.addListener(this.m_listener);
        this.createChildren();
    }

    @Override
    protected void createChildren() {
    }

    @Override
    public void dispose() {
        super.dispose();
        this.m_project.removeListener(this.m_listener);
        this.deleteChildren();
    }

    @Override
    public void doubleClicked() {
    }

    @Override
    public Icon getIcon() {
        return ICON_VIEW;
    }

    @Override
    public String toString() {
        List<INaviView> views = this.m_project.getContent().getViews();
        int count = CViewFilter.getCallgraphViewCount(views);
        count += CViewFilter.getFlowgraphViewCount(views);
        return String.format("Project Views (%d)", count += CViewFilter.getMixedgraphViewCount(views));
    }

    private class InternalProjectListener
    extends CProjectListenerAdapter {
        private InternalProjectListener() {
        }

        @Override
        public void addedView(INaviProject container, INaviView view) {
            CProjectViewsContainerNode.this.getTreeModel().nodeChanged(CProjectViewsContainerNode.this);
        }

        @Override
        public void deletedView(INaviProject container, INaviView view) {
            CProjectViewsContainerNode.this.getTreeModel().nodeChanged(CProjectViewsContainerNode.this);
        }
    }
}

