/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Views.Module.Component;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CAbstractTreeViewsTableModel;
import com.google.security.zynamics.binnavi.disassembly.ICallgraphView;
import com.google.security.zynamics.binnavi.disassembly.INaviEdge;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.binnavi.disassembly.Modules.CModuleListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.views.CViewListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.general.comparators.IntComparator;
import com.google.security.zynamics.zylib.types.graphs.IDirectedGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public final class CNativeCallgraphsViewsModel
extends CAbstractTreeViewsTableModel {
    private static final long serialVersionUID = 1992422414886514519L;
    private static final String[] COLUMN_NAMES = new String[]{"Name", "Description", "Functions", "Edges"};
    private static final int NAME_COLUMN = 0;
    private static final int DESCRIPTION_COLUMN = 1;
    private static final int FUNCTION_COUNT_COLUMN = 2;
    private static final int EDGE_COUNT_COLUMN = 3;
    private final INaviModule m_module;
    private final InternalViewListener m_viewListener = new InternalViewListener();
    private final InternalModuleListener m_moduleListener = new InternalModuleListener();

    public CNativeCallgraphsViewsModel(INaviModule module) {
        Preconditions.checkNotNull(module, "IE02049: Module argument can't be null");
        this.m_module = module;
        module.addListener(this.m_moduleListener);
        this.initListeners();
    }

    private void initListeners() {
        if (this.m_module.isLoaded()) {
            this.m_module.getContent().getViewContainer().getNativeCallgraphView().addListener(this.m_viewListener);
        }
    }

    @Override
    public void delete() {
        this.m_module.removeListener(this.m_moduleListener);
        if (this.m_module.isLoaded()) {
            this.m_module.getContent().getViewContainer().getNativeCallgraphView().removeListener(this.m_viewListener);
        }
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    @Override
    public int getRowCount() {
        return this.m_module.isLoaded() ? 1 : 0;
    }

    @Override
    public List<Pair<Integer, Comparator<?>>> getSorters() {
        ArrayList sorters = new ArrayList();
        sorters.add(new Pair<Integer, IntComparator>(2, new IntComparator()));
        sorters.add(new Pair<Integer, IntComparator>(3, new IntComparator()));
        return sorters;
    }

    @Override
    public Object getValueAt(int row, int col) {
        ICallgraphView view = this.m_module.getContent().getViewContainer().getNativeCallgraphView();
        switch (col) {
            case 0: {
                return view.getName();
            }
            case 1: {
                return view.getConfiguration().getDescription();
            }
            case 2: {
                return view.getNodeCount();
            }
            case 3: {
                return view.getEdgeCount();
            }
        }
        throw new IllegalStateException("IE02246: Unknown column");
    }

    @Override
    public List<INaviView> getViews() {
        ArrayList<INaviView> views = new ArrayList<INaviView>();
        views.add(this.m_module.getContent().getViewContainer().getNativeCallgraphView());
        return views;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return 1 == column;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        if (column == 1) {
            ICallgraphView view = this.m_module.getContent().getViewContainer().getNativeCallgraphView();
            try {
                view.getConfiguration().setDescription((String)value);
                this.fireTableDataChanged();
            }
            catch (CouldntSaveDataException e2) {
                CUtilityFunctions.logException(e2);
            }
        }
    }

    private class InternalViewListener
    extends CViewListenerAdapter {
        private InternalViewListener() {
        }

        @Override
        public void addedEdge(INaviView view, INaviEdge node) {
            CNativeCallgraphsViewsModel.this.fireTableDataChanged();
        }

        @Override
        public void addedNode(INaviView view, INaviViewNode node) {
            CNativeCallgraphsViewsModel.this.fireTableDataChanged();
        }

        @Override
        public void changedDescription(INaviView view, String description) {
            CNativeCallgraphsViewsModel.this.fireTableDataChanged();
        }

        @Override
        public void changedModificationDate(INaviView view, Date modificationDate) {
            CNativeCallgraphsViewsModel.this.fireTableDataChanged();
        }

        @Override
        public void changedName(INaviView view, String name) {
            CNativeCallgraphsViewsModel.this.fireTableDataChanged();
        }

        @Override
        public void closedView(INaviView view, IDirectedGraph<INaviViewNode, INaviEdge> oldGraph) {
            CNativeCallgraphsViewsModel.this.fireTableDataChanged();
        }

        @Override
        public void deletedEdge(INaviView view, INaviEdge edge) {
            CNativeCallgraphsViewsModel.this.fireTableDataChanged();
        }

        @Override
        public void deletedNode(INaviView view, INaviViewNode node) {
            CNativeCallgraphsViewsModel.this.fireTableDataChanged();
        }

        @Override
        public void deletedNodes(INaviView view, Collection<INaviViewNode> nodes) {
            CNativeCallgraphsViewsModel.this.fireTableDataChanged();
        }

        @Override
        public void loadedView(INaviView view) {
            CNativeCallgraphsViewsModel.this.fireTableDataChanged();
        }

        @Override
        public void savedView(INaviView view) {
            CNativeCallgraphsViewsModel.this.fireTableDataChanged();
        }
    }

    private class InternalModuleListener
    extends CModuleListenerAdapter {
        private InternalModuleListener() {
        }

        @Override
        public void loadedModule(INaviModule module) {
            CNativeCallgraphsViewsModel.this.initListeners();
            CNativeCallgraphsViewsModel.this.fireTableDataChanged();
        }
    }
}

