/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Views.Module.Component;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.IFilter;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CAbstractTreeViewsTableModel;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Views.Module.Component.CFunctionNameTypePair;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Views.Module.Component.FunctionNameComparator;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.Breakpoint;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointManager;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointManagerListenerAdapter;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.enums.BreakpointStatus;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.interfaces.BreakpointManagerListener;
import com.google.security.zynamics.binnavi.disassembly.ICallgraphView;
import com.google.security.zynamics.binnavi.disassembly.IFlowgraphView;
import com.google.security.zynamics.binnavi.disassembly.INaviEdge;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.binnavi.disassembly.Modules.CModule;
import com.google.security.zynamics.binnavi.disassembly.Modules.CModuleListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.algorithms.CStaredItemFunctions;
import com.google.security.zynamics.binnavi.disassembly.views.CViewListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.zylib.disassembly.GraphType;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.disassembly.IFunction;
import com.google.security.zynamics.zylib.disassembly.IFunctionListener;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.general.comparators.HexStringComparator;
import com.google.security.zynamics.zylib.general.comparators.IntComparator;
import com.google.security.zynamics.zylib.types.graphs.IDirectedGraph;
import com.google.security.zynamics.zylib.types.lists.FilledList;
import com.google.security.zynamics.zylib.types.lists.IFilledList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CFunctionViewsModel
extends CAbstractTreeViewsTableModel {
    private static final long serialVersionUID = 6047574847073142955L;
    private static final String[] COLUMN_NAMES = new String[]{"Address", "Name", "Description", "Module", "Forwarded to", "Basic Blocks", "Edges", "In", "Out"};
    private static final int ADDRESS_COLUM = 0;
    private static final int FUNCTIONNAME_COLUM = 1;
    private static final int DESCRIPTION_COLUMN = 2;
    private static final int MODULE_COLUMN = 3;
    private static final int FORWARDER_COLUMN = 4;
    private static final int BASICBLOCK_COUNT_COLUMN = 5;
    private static final int EDGE_COUNT_COLUMN = 6;
    private static final int INCOMING_CALLS_COUNT_COLUMN = 7;
    private static final int OUTGOING_CALLS_COUNT_COLUMN = 8;
    private final IDatabase m_database;
    private final INaviModule m_module;
    private final InternalModuleListener m_moduleListener = new InternalModuleListener();
    private final InternalViewListener m_viewListener = new InternalViewListener();
    private IFilledList<INaviView> m_cachedValues = null;
    private final BreakpointManagerListener m_breakpointManagerListener = new InternalBreakpointManagerListener();
    private IDebugger m_activeDebugger;

    public CFunctionViewsModel(IDatabase database, INaviModule module) {
        this.m_module = Preconditions.checkNotNull(module, "IE01215: Module can't be null");
        this.m_database = database;
        module.addListener(this.m_moduleListener);
        this.m_activeDebugger = module.getConfiguration().getDebugger();
        if (this.m_activeDebugger != null) {
            BreakpointManager manager = this.m_activeDebugger.getBreakpointManager();
            manager.addListener(this.m_breakpointManagerListener);
        }
        if (module.isLoaded()) {
            for (IFlowgraphView view : this.m_module.getContent().getViewContainer().getNativeFlowgraphViews()) {
                view.addListener(this.m_viewListener);
            }
            for (INaviFunction function : this.m_module.getContent().getFunctionContainer().getFunctions()) {
                function.addListener(this.m_viewListener);
            }
        }
    }

    private IFilledList<INaviView> convert(ImmutableList<IFlowgraphView> nativeFlowgraphViews) {
        FilledList<INaviView> views = new FilledList<INaviView>();
        for (IFlowgraphView flowgraphView : nativeFlowgraphViews) {
            views.add(flowgraphView);
        }
        return views;
    }

    private int getEdgeCount(INaviView view, INaviFunction function) {
        if (view.isLoaded() || function.getForwardedFunctionAddress() == null) {
            return view.getEdgeCount();
        }
        INaviModule forwardedModule = this.m_database.getContent().getModule(function.getForwardedFunctionModuleId());
        Preconditions.checkNotNull(forwardedModule, "IE01186: Unknown forwarded module");
        if (forwardedModule.isLoaded()) {
            INaviFunction forwardedFunction = forwardedModule.getContent().getFunctionContainer().getFunction(function.getForwardedFunctionAddress());
            Preconditions.checkNotNull(forwardedFunction, "IE01185: Unknown forwarded function");
            return forwardedFunction.getEdgeCount();
        }
        return 0;
    }

    private String getForwarderColumnText(INaviFunction function) {
        IAddress address = function.getForwardedFunctionAddress();
        if (address == null) {
            return "-";
        }
        int moduleId = function.getForwardedFunctionModuleId();
        INaviModule forwardedModule = this.m_database.getContent().getModule(moduleId);
        if (forwardedModule == null) {
            return "INVALID";
        }
        if (!forwardedModule.isLoaded()) {
            return String.format("%s:%s", forwardedModule.getConfiguration().getName(), address.toHexString());
        }
        INaviFunction forwardedFunction = forwardedModule.getContent().getFunctionContainer().getFunction(address);
        if (forwardedFunction == null) {
            return "INVALID";
        }
        return String.format("%s:%s", forwardedModule.getConfiguration().getName(), forwardedFunction.getName());
    }

    private int getNodeCount(INaviView view, INaviFunction function) {
        if (view.isLoaded() || function.getForwardedFunctionAddress() == null) {
            return view.getNodeCount();
        }
        INaviModule forwardedModule = this.m_database.getContent().getModule(function.getForwardedFunctionModuleId());
        Preconditions.checkNotNull(forwardedModule, "IE01188: Unknown forwarded module");
        if (forwardedModule.isLoaded()) {
            INaviFunction forwardedFunction = forwardedModule.getContent().getFunctionContainer().getFunction(function.getForwardedFunctionAddress());
            Preconditions.checkNotNull(forwardedFunction, "IE01187: Unknown forwarded function");
            return forwardedFunction.getBasicBlockCount();
        }
        return 0;
    }

    @Override
    public void delete() {
        this.m_module.removeListener(this.m_moduleListener);
        if (this.m_activeDebugger != null) {
            BreakpointManager manager = this.m_activeDebugger.getBreakpointManager();
            manager.removeListener(this.m_breakpointManagerListener);
        }
        if (this.m_module.isLoaded()) {
            for (IFlowgraphView view : this.m_module.getContent().getViewContainer().getNativeFlowgraphViews()) {
                view.removeListener(this.m_viewListener);
            }
            for (INaviFunction function : this.m_module.getContent().getFunctionContainer().getFunctions()) {
                function.removeListener(this.m_viewListener);
            }
        }
    }

    @Override
    public final int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public final String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    @Override
    public final int getRowCount() {
        return this.getViews().size();
    }

    @Override
    public final List<Pair<Integer, Comparator<?>>> getSorters() {
        ArrayList sorters = new ArrayList();
        sorters.add(new Pair<Integer, HexStringComparator>(0, new HexStringComparator()));
        sorters.add(new Pair<Integer, FunctionNameComparator>(1, new FunctionNameComparator()));
        sorters.add(new Pair<Integer, IntComparator>(5, new IntComparator()));
        sorters.add(new Pair<Integer, IntComparator>(6, new IntComparator()));
        sorters.add(new Pair<Integer, IntComparator>(7, new IntComparator()));
        sorters.add(new Pair<Integer, IntComparator>(8, new IntComparator()));
        return sorters;
    }

    @Override
    public final Object getValueAt(int row, int col) {
        List<INaviView> views = this.m_cachedValues == null ? this.getViews() : this.m_cachedValues;
        INaviView view = views.get(row);
        INaviFunction function = this.m_module.getContent().getViewContainer().getFunction(view);
        Preconditions.checkNotNull(function, "IE01189: View without known function");
        switch (col) {
            case 0: {
                return function.getAddress().toHexString();
            }
            case 1: {
                return new CFunctionNameTypePair(view.getName(), function.getType());
            }
            case 2: {
                return view.getConfiguration().getDescription();
            }
            case 3: {
                return function.getOriginalModulename();
            }
            case 4: {
                return this.getForwarderColumnText(function);
            }
            case 5: {
                return this.getNodeCount(view, function);
            }
            case 6: {
                return this.getEdgeCount(view, function);
            }
            case 7: {
                return function.getIndegree();
            }
            case 8: {
                return function.getOutdegree();
            }
        }
        throw new IllegalStateException("IE02245: Unknown column");
    }

    @Override
    public synchronized List<INaviView> getViews() {
        IFilledList<INaviView> localCachedValues = this.m_cachedValues;
        if (localCachedValues == null) {
            IFilter<INaviView> filter = this.getFilter();
            localCachedValues = this.m_module.isLoaded() ? (filter == null ? this.convert(this.m_module.getContent().getViewContainer().getNativeFlowgraphViews()) : filter.get(this.convert(this.m_module.getContent().getViewContainer().getNativeFlowgraphViews()))) : new FilledList<INaviView>();
            CStaredItemFunctions.sort(localCachedValues);
        }
        this.m_cachedValues = localCachedValues;
        return new ArrayList<INaviView>(localCachedValues);
    }

    @Override
    public final boolean isCellEditable(int row, int column) {
        return 1 == column || 2 == column;
    }

    @Override
    public void setFilter(IFilter<INaviView> filter) {
        this.m_cachedValues = null;
        super.setFilter(filter);
    }

    @Override
    public final void setValueAt(Object value, int row, int column) {
        INaviView view = this.getViews().get(row);
        if (column == 2) {
            try {
                view.getConfiguration().setDescription((String)value);
            }
            catch (Exception e2) {
                CUtilityFunctions.logException(e2);
                String innerMessage = "E00188: View name could not be changed";
                String innerDescription = CUtilityFunctions.createDescription(String.format("The view name of view '%s' could not be changed.", view.getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The view was not updated and the new view name is lost."});
                NaviErrorDialog.show(null, "E00188: View name could not be changed", innerDescription, e2);
            }
        } else if (column == 1) {
            try {
                view.getConfiguration().setName((String)value);
            }
            catch (Exception e3) {
                CUtilityFunctions.logException(e3);
                String innerMessage = "E00189: View description could not be changed";
                String innerDescription = CUtilityFunctions.createDescription(String.format("The view description of view '%s' could not be changed.", view.getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The view was not updated and the new view description is lost."});
                NaviErrorDialog.show(null, "E00189: View description could not be changed", innerDescription, e3);
            }
        }
    }

    private class InternalViewListener
    extends CViewListenerAdapter
    implements IFunctionListener<IComment> {
        private InternalViewListener() {
        }

        @Override
        public void addedEdge(INaviView view, INaviEdge node) {
            CFunctionViewsModel.this.m_cachedValues = null;
            CFunctionViewsModel.this.fireTableDataChanged();
        }

        @Override
        public void addedNode(INaviView view, INaviViewNode node) {
            CFunctionViewsModel.this.m_cachedValues = null;
            CFunctionViewsModel.this.fireTableDataChanged();
        }

        @Override
        public void appendedComment(IFunction function, IComment comment) {
        }

        @Override
        public void changedDescription(IFunction function, String description) {
            CFunctionViewsModel.this.m_cachedValues = null;
        }

        @Override
        public void changedDescription(INaviView view, String description) {
            CFunctionViewsModel.this.m_cachedValues = null;
            CFunctionViewsModel.this.fireTableDataChanged();
        }

        @Override
        public void changedGraphType(INaviView view, GraphType type, GraphType oldType) {
            CFunctionViewsModel.this.m_cachedValues = null;
            CFunctionViewsModel.this.fireTableDataChanged();
        }

        @Override
        public void changedModificationDate(INaviView view, Date modificationDate) {
            CFunctionViewsModel.this.m_cachedValues = null;
            CFunctionViewsModel.this.fireTableDataChanged();
        }

        @Override
        public void changedName(IFunction function, String name) {
            CFunctionViewsModel.this.m_cachedValues = null;
        }

        @Override
        public void changedName(INaviView view, String name) {
            CFunctionViewsModel.this.m_cachedValues = null;
            CFunctionViewsModel.this.fireTableDataChanged();
        }

        @Override
        public void changedForwardedFunction(IFunction function) {
            CFunctionViewsModel.this.m_cachedValues = null;
            CFunctionViewsModel.this.fireTableDataChanged();
        }

        @Override
        public void changedStarState(INaviView view, boolean isStared) {
            CFunctionViewsModel.this.m_cachedValues = null;
            CFunctionViewsModel.this.fireTableDataChanged();
        }

        @Override
        public void closed(IFunction function) {
        }

        @Override
        public void closedView(INaviView view, IDirectedGraph<INaviViewNode, INaviEdge> oldGraph) {
            CFunctionViewsModel.this.m_cachedValues = null;
            CFunctionViewsModel.this.fireTableDataChanged();
        }

        @Override
        public void deletedComment(IFunction function, IComment comment) {
        }

        @Override
        public void deletedEdge(INaviView view, INaviEdge edge) {
            CFunctionViewsModel.this.m_cachedValues = null;
            CFunctionViewsModel.this.fireTableDataChanged();
        }

        @Override
        public void deletedNode(INaviView view, INaviViewNode node) {
            CFunctionViewsModel.this.m_cachedValues = null;
            CFunctionViewsModel.this.fireTableDataChanged();
        }

        @Override
        public void deletedNodes(INaviView view, Collection<INaviViewNode> nodes) {
            CFunctionViewsModel.this.m_cachedValues = null;
            CFunctionViewsModel.this.fireTableDataChanged();
        }

        @Override
        public void editedComment(IFunction function, IComment comment) {
        }

        @Override
        public void initializedComment(IFunction function, List<IComment> comment) {
        }

        @Override
        public void loadedFunction(IFunction function) {
            CFunctionViewsModel.this.m_cachedValues = null;
        }

        @Override
        public void savedView(INaviView view) {
            CFunctionViewsModel.this.m_cachedValues = null;
            CFunctionViewsModel.this.fireTableDataChanged();
        }
    }

    private class InternalModuleListener
    extends CModuleListenerAdapter {
        private InternalModuleListener() {
        }

        @Override
        public void changedDebugger(INaviModule module, IDebugger debugger) {
            if (CFunctionViewsModel.this.m_activeDebugger != null) {
                CFunctionViewsModel.this.m_activeDebugger.getBreakpointManager().removeListener(CFunctionViewsModel.this.m_breakpointManagerListener);
            }
            CFunctionViewsModel.this.m_activeDebugger = debugger;
            if (debugger != null) {
                debugger.getBreakpointManager().addListener(CFunctionViewsModel.this.m_breakpointManagerListener);
            }
            CFunctionViewsModel.this.fireTableDataChanged();
        }

        @Override
        public void changedName(INaviModule module, String name) {
            CFunctionViewsModel.this.m_cachedValues = null;
            CFunctionViewsModel.this.fireTableDataChanged();
        }

        @Override
        public void closedModule(CModule module, ICallgraphView callgraphView, List<IFlowgraphView> flowgraphs) {
            CFunctionViewsModel.this.m_cachedValues = null;
        }

        @Override
        public void loadedModule(INaviModule module) {
            CFunctionViewsModel.this.m_cachedValues = null;
            for (IFlowgraphView view : CFunctionViewsModel.this.m_module.getContent().getViewContainer().getNativeFlowgraphViews()) {
                view.addListener(CFunctionViewsModel.this.m_viewListener);
            }
            for (INaviFunction function : CFunctionViewsModel.this.m_module.getContent().getFunctionContainer().getFunctions()) {
                function.addListener(CFunctionViewsModel.this.m_viewListener);
            }
            CFunctionViewsModel.this.fireTableDataChanged();
        }
    }

    private class InternalBreakpointManagerListener
    extends BreakpointManagerListenerAdapter {
        private InternalBreakpointManagerListener() {
        }

        @Override
        public void breakpointsAdded(List<Breakpoint> breakpoints) {
            CFunctionViewsModel.this.fireTableDataChanged();
        }

        @Override
        public void breakpointsRemoved(Set<Breakpoint> breakpoints) {
            CFunctionViewsModel.this.fireTableDataChanged();
        }

        @Override
        public void breakpointsStatusChanged(Map<Breakpoint, BreakpointStatus> breakpointsToOldStatus, BreakpointStatus newStatus) {
            CFunctionViewsModel.this.fireTableDataChanged();
        }
    }
}

