/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Views.Component;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CMain;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphPanel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphWindow;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.IGraphContainerWindow;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.IGraphWindowListener;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CProjectTreeTableRenderer;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Views.Component.CAddressLabel;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Views.Component.CLoadProgressPainter;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Views.Component.IViewsTable;
import com.google.security.zynamics.binnavi.Gui.WindowManager.CWindowManager;
import com.google.security.zynamics.binnavi.Gui.WindowManager.IWindowManagerListener;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.algorithms.CFunctionNodeColorizer;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.disassembly.views.IViewContainer;
import com.google.security.zynamics.zylib.disassembly.FunctionType;
import com.google.security.zynamics.zylib.disassembly.GraphType;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class CViewsTableRenderer
implements TableCellRenderer {
    private final IViewsTable table;
    private final IViewContainer container;
    private final InternalGraphWindowListener listener = new InternalGraphWindowListener();
    private final InternalGraphPanelListener panelListener = new InternalGraphPanelListener();
    private static Font normalFont;
    private static Font normalBoldFont;
    private static Image starImage;

    public CViewsTableRenderer(IViewsTable table, IViewContainer container) {
        this.container = Preconditions.checkNotNull(container, "IE02032: Container argument can't be null");
        this.table = Preconditions.checkNotNull(table, "IE02351: table argument can not be null");
        if (starImage == null) {
            try {
                starImage = new ImageIcon(CMain.class.getResource("data/star.png").toURI().toURL()).getImage();
            }
            catch (MalformedURLException | URISyntaxException exception) {
                // empty catch block
            }
        }
        CWindowManager.instance().addListener(this.listener);
        for (CGraphWindow window : CWindowManager.instance().getOpenWindows()) {
            window.addListener(this.panelListener);
        }
    }

    private Color getBackgroundColor(IViewsTable table, boolean isSelected, FunctionType functionType, GraphType graphType) {
        if (isSelected) {
            return table.self().getSelectionBackground();
        }
        if (graphType == GraphType.FLOWGRAPH && functionType == FunctionType.NORMAL) {
            return Color.WHITE;
        }
        return CFunctionNodeColorizer.getFunctionColor(functionType);
    }

    public void dispose() {
        CWindowManager.instance().removeListener(this.listener);
        for (CGraphWindow window : CWindowManager.instance().getOpenWindows()) {
            window.removeListener(this.panelListener);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        IDebugger debugger;
        INaviView view = this.table.getUnsortedView(row);
        if (view == null) {
            return new JLabel("No cross references");
        }
        INaviFunction function = this.container.getFunction(view);
        if (column == 0 && function != null && (debugger = this.container.getDebuggerProvider().getDebugger(function.getModule())) != null) {
            return new CAddressLabel(table, view, debugger, function, this.getBackgroundColor(this.table, isSelected, function.getType(), view.getGraphType()), null);
        }
        return new ViewLabel(value, isSelected, row, column, null);
    }

    public class ViewLabel
    extends CProjectTreeTableRenderer {
        private static final long serialVersionUID = 2794817948190337490L;
        private final INaviView m_view;
        private final int m_column;
        private final Object m_value;

        public ViewLabel(Object value, boolean isSelected, int row, int column, Font font) {
            super.setText("### ");
            this.m_column = column;
            this.m_value = value;
            if (font == null) {
                normalFont = new Font(this.getFont().getFontName(), 0, 12);
                normalBoldFont = new Font(this.getFont().getFontName(), 1, 12);
            } else {
                normalFont = new Font(font.getName(), 0, font.getSize());
                normalBoldFont = new Font(font.getName(), 1, font.getSize());
            }
            this.m_view = CViewsTableRenderer.this.table.getUnsortedView(row);
            GraphType graphType = this.m_view.getGraphType();
            FunctionType functionType = FunctionType.NORMAL;
            INaviFunction function = CViewsTableRenderer.this.container.getFunction(this.m_view);
            if (function != null) {
                functionType = function.getType();
            }
            this.setBackground(CViewsTableRenderer.this.getBackgroundColor(CViewsTableRenderer.this.table, isSelected, functionType, graphType));
        }

        @Override
        public void paint(Graphics graphics) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (this.m_column == CViewsTableRenderer.this.table.getNameColumn()) {
                CLoadProgressPainter.paint(this.m_view, graphics, this.getWidth(), this.getHeight(), this.getBackground());
                if (this.m_view.isStared()) {
                    graphics.drawImage(starImage, 0, 0, this.getHeight() - 2, this.getHeight() - 2, null);
                }
            }
            if (this.m_value == null) {
                return;
            }
            boolean isOpen = CWindowManager.instance().isOpen(this.m_view);
            graphics.setColor(Color.BLACK);
            graphics.setFont(isOpen ? normalBoldFont : normalFont);
            graphics.drawString(this.m_value.toString(), this.m_column == CViewsTableRenderer.this.table.getNameColumn() && this.m_view.isStared() ? this.getHeight() : 0, 12);
        }
    }

    private class InternalGraphWindowListener
    implements IWindowManagerListener {
        private InternalGraphWindowListener() {
        }

        @Override
        public void windowClosed(CWindowManager windowManager, IGraphContainerWindow window) {
            window.removeListener(CViewsTableRenderer.this.panelListener);
        }

        @Override
        public void windowOpened(CWindowManager windowManager, IGraphContainerWindow window) {
            window.addListener(CViewsTableRenderer.this.panelListener);
        }
    }

    private class InternalGraphPanelListener
    implements IGraphWindowListener {
        private InternalGraphPanelListener() {
        }

        @Override
        public void graphPanelClosed() {
        }

        @Override
        public void graphPanelOpened(CGraphPanel graphPanel) {
        }
    }
}

