/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Views.Component;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CMain;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Implementations.CGraphDebugger;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Views.Component.CBreakpointImage;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Views.Component.CLoadProgressPainter;
import com.google.security.zynamics.binnavi.Gui.WindowManager.CWindowManager;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointManager;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.enums.BreakpointStatus;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.UnrelocatedAddress;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;

public final class CAddressLabel
extends JLabel {
    private static final long serialVersionUID = 3817187213259813776L;
    private static Font normalFont;
    private static Font normalBoldFont;
    private final JTable table;
    private final INaviView view;
    private final IDebugger debugger;
    private final INaviFunction function;
    private static Image starImage;

    public CAddressLabel(JTable table, INaviView view, IDebugger debugger, INaviFunction function, Color backgroundColor, Font font) {
        this.debugger = Preconditions.checkNotNull(debugger, "IE02019: Debugger argument can not be null");
        this.function = Preconditions.checkNotNull(function, "IE02020: Function argument can not be null");
        this.table = Preconditions.checkNotNull(table, "IE02348: Table argument can not be null");
        this.view = Preconditions.checkNotNull(view, "IE02349: View argument can not be null");
        if (starImage == null) {
            try {
                starImage = new ImageIcon(CMain.class.getResource("data/star.png").toURI().toURL()).getImage();
            }
            catch (MalformedURLException | URISyntaxException exception) {
                // empty catch block
            }
        }
        if (font == null) {
            normalFont = new Font(this.getFont().getFontName(), 0, 12);
            normalBoldFont = new Font(this.getFont().getFontName(), 1, 12);
        } else {
            normalFont = new Font(font.getName(), 0, font.getSize());
            normalBoldFont = new Font(font.getName(), 1, font.getSize());
        }
        this.setBackground(backgroundColor);
        this.setOpaque(true);
    }

    @Override
    public void paint(Graphics graphics) {
        CLoadProgressPainter.paint(this.view, graphics, this.getWidth(), this.getHeight(), this.getBackground());
        if (this.view.isStared()) {
            graphics.drawImage(starImage, 0, 0, this.getHeight() - 2, this.getHeight() - 2, this.table);
        }
        UnrelocatedAddress fileAddress = new UnrelocatedAddress(this.function.getAddress());
        if (CGraphDebugger.hasBreakpoint(this.debugger.getBreakpointManager(), this.function.getModule(), fileAddress)) {
            BreakpointStatus breakpointStatus = CGraphDebugger.getBreakpointStatus(this.debugger.getBreakpointManager(), this.function.getModule(), fileAddress);
            CBreakpointImage img = new CBreakpointImage(this.getBackground(), BreakpointManager.getBreakpointColor(breakpointStatus));
            int x2 = this.getWidth() - img.getWidth() - 2;
            int y2 = this.getHeight() / 2 - img.getHeight() / 2;
            ((Graphics2D)graphics).drawImage(img, null, x2, y2);
        }
        boolean isOpen = CWindowManager.instance().isOpen(this.view);
        graphics.setColor(Color.BLACK);
        graphics.setFont(isOpen ? normalBoldFont : normalFont);
        graphics.drawString(this.function.getAddress().toHexString(), this.view.isStared() ? this.getHeight() : 0, 12);
    }
}

