/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Traces.Component;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Gui.CProgressDialog;
import com.google.security.zynamics.binnavi.Gui.Debug.EventLists.CDebugEventListPanel;
import com.google.security.zynamics.binnavi.Gui.Debug.EventLists.CEventListTable;
import com.google.security.zynamics.binnavi.Gui.Debug.EventLists.CEventListTableMenu;
import com.google.security.zynamics.binnavi.Gui.Debug.EventLists.CEventTableMenu;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.CTablePanel;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CAbstractNodeComponent;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Traces.Component.CArbitraryViewsModel;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Traces.Component.CArbitraryViewsTable;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Traces.Component.Help.CTracesViewsTableHelp;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Views.Help.CViewFilterHelp;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.filters.CViewFilterCreator;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.debug.models.trace.TraceList;
import com.google.security.zynamics.binnavi.debug.models.trace.interfaces.ITraceEvent;
import com.google.security.zynamics.binnavi.disassembly.CProjectContainer;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.UnrelocatedAddress;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.disassembly.views.IViewContainer;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.CEndlessHelperThread;
import com.google.security.zynamics.zylib.types.lists.FilledList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public final class CTracesNodeComponent
extends CAbstractNodeComponent {
    private static final long serialVersionUID = 2169183737568464057L;
    private final IViewContainer m_container;
    private final CDebugEventListPanel m_tracesPanel;
    private final CArbitraryViewsModel m_model = new CArbitraryViewsModel();
    private final ListSelectionListener m_listener = new InternalSelectionListener();

    public CTracesNodeComponent(JTree projectTree, IViewContainer container) {
        super(new BorderLayout());
        Preconditions.checkNotNull(projectTree, "IE02007: Project tree argument can not be null");
        this.m_container = Preconditions.checkNotNull(container, "IE02008: Container argument can not be null");
        this.setBorder(new TitledBorder("Debug Traces"));
        this.m_tracesPanel = new CDebugEventListPanel(this.m_container.getTraceProvider());
        CArbitraryViewsTable table = new CArbitraryViewsTable(projectTree, this.m_model, container, new CTracesViewsTableHelp());
        CTablePanel<INaviView> lowerPanel = new CTablePanel<INaviView>(table, new CViewFilterCreator(container), new CViewFilterHelp());
        lowerPanel.setBorder(new TitledBorder("Views"));
        lowerPanel.add(new JScrollPane(table));
        JSplitPane splitPane = new JSplitPane(0, true, this.m_tracesPanel, lowerPanel);
        this.add((Component)splitPane, "Center");
        splitPane.setResizeWeight(0.5);
        this.m_tracesPanel.getTracesTable().getSelectionModel().addListSelectionListener(this.m_listener);
        this.m_tracesPanel.getTracesTable().addMouseListener(new InternalTraceTableListener());
        this.m_tracesPanel.getEventsTable().addMouseListener(new InternalEventsTableListener());
    }

    private void showRelevantViews(TraceList trace2) throws CouldntLoadDataException {
        FilledList<UnrelocatedAddress> addresses = new FilledList<UnrelocatedAddress>();
        for (ITraceEvent traceEvent : trace2) {
            addresses.add(traceEvent.getOffset().getAddress());
        }
        List<INaviView> views = this.m_container.getViewsWithAddresses(addresses, false);
        if (this.m_container instanceof CProjectContainer) {
            for (INaviModule module : this.m_container.getModules()) {
                if (!module.isLoaded()) continue;
                views.addAll(module.getViewsWithAddresses(addresses, false));
            }
        }
        this.m_model.setViews(views);
    }

    @Override
    public void dispose() {
        this.m_tracesPanel.dispose();
    }

    private class LoadRelevantViewsThread
    extends CEndlessHelperThread {
        private final TraceList m_list;

        public LoadRelevantViewsThread(TraceList list) {
            this.m_list = list;
        }

        @Override
        protected void runExpensiveCommand() throws Exception {
            CTracesNodeComponent.this.showRelevantViews(this.m_list);
        }

        @Override
        public void closeRequested() {
            this.finish();
        }
    }

    private class InternalTraceTableListener
    extends MouseAdapter {
        private InternalTraceTableListener() {
        }

        private void showPopupMenu(MouseEvent event) {
            int minIndex;
            int[] rows;
            CEventListTable traceTable = CTracesNodeComponent.this.m_tracesPanel.getTracesTable();
            int mouseRow = traceTable.rowAtPoint(event.getPoint());
            if (mouseRow != -1 && Ints.asList(rows = traceTable.getSelectedRows()).indexOf(mouseRow) != -1) {
                traceTable.setRowSelectionInterval(mouseRow, mouseRow);
            }
            if ((minIndex = CTracesNodeComponent.this.m_tracesPanel.getTracesTable().getSelectionModel().getMinSelectionIndex()) != -1) {
                CEventListTableMenu popupMenu = new CEventListTableMenu((JFrame)SwingUtilities.getWindowAncestor(CTracesNodeComponent.this), CTracesNodeComponent.this.m_tracesPanel.getTracesTable(), CTracesNodeComponent.this.m_container.getTraceProvider());
                popupMenu.show(CTracesNodeComponent.this.m_tracesPanel.getTracesTable(), event.getX(), event.getY());
            }
        }

        @Override
        public void mousePressed(MouseEvent event) {
            if (event.isPopupTrigger()) {
                this.showPopupMenu(event);
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            if (event.isPopupTrigger()) {
                this.showPopupMenu(event);
            }
        }
    }

    private class InternalSelectionListener
    implements ListSelectionListener {
        private InternalSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            boolean single;
            int first = CTracesNodeComponent.this.m_tracesPanel.getTracesTable().getSelectionModel().getMinSelectionIndex();
            if (first == -1) {
                CTracesNodeComponent.this.m_model.setViews(new FilledList<INaviView>());
                return;
            }
            boolean bl2 = single = first == CTracesNodeComponent.this.m_tracesPanel.getTracesTable().getSelectionModel().getMaxSelectionIndex();
            if (single) {
                CEventListTable table = CTracesNodeComponent.this.m_tracesPanel.getTracesTable();
                TraceList list = CTracesNodeComponent.this.m_tracesPanel.getTracesTable().getTreeTableModel().getTraces().get(table.convertRowIndexToModel(first));
                LoadRelevantViewsThread thread2 = new LoadRelevantViewsThread(list);
                CProgressDialog.showEndless(SwingUtilities.getWindowAncestor(CTracesNodeComponent.this.getParent()), "Loading views that belong to the selected trace", thread2);
                if (thread2.getException() != null) {
                    String innerMessage = "E00042: Could not load relevant views";
                    String innerDescription = CUtilityFunctions.createDescription(String.format("BinNavi could not load the views that belong to the trace '%s'.", list.getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The views that belong to the trace can not be shown."});
                    NaviErrorDialog.show(SwingUtilities.getWindowAncestor(CTracesNodeComponent.this.getParent()), "E00042: Could not load relevant views", innerDescription, thread2.getException());
                }
            }
        }
    }

    private class InternalEventsTableListener
    extends MouseAdapter {
        private InternalEventsTableListener() {
        }

        private List<ITraceEvent> getTraces(int[] rows) {
            ArrayList<ITraceEvent> events = new ArrayList<ITraceEvent>();
            for (int row : rows) {
                events.add(CTracesNodeComponent.this.m_tracesPanel.getEventsTable().getTreeTableModel().getEvents().get(row));
            }
            return events;
        }

        private void showPopupMenu(MouseEvent event) {
            int[] rows = CTracesNodeComponent.this.m_tracesPanel.getEventsTable().getConvertedSelectedRows();
            List<ITraceEvent> traces = this.getTraces(rows);
            CEventTableMenu menu = new CEventTableMenu(CTracesNodeComponent.this.m_tracesPanel.getEventsTable(), traces);
            menu.show(CTracesNodeComponent.this.m_tracesPanel.getEventsTable(), event.getX(), event.getY());
        }

        @Override
        public void mousePressed(MouseEvent event) {
            if (event.isPopupTrigger()) {
                this.showPopupMenu(event);
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            if (event.isPopupTrigger()) {
                this.showPopupMenu(event);
            }
        }
    }
}

