/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Traces;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CMain;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CAbstractLazyComponent;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CAbstractNodeComponent;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CProjectTreeNode;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Root.CRootNodeMenuBuilder;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Traces.Component.CTracesNodeComponent;
import com.google.security.zynamics.binnavi.debug.models.trace.TraceList;
import com.google.security.zynamics.binnavi.debug.models.trace.interfaces.ITraceManagerListener;
import com.google.security.zynamics.binnavi.disassembly.views.IViewContainer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;

public final class CTracesNode
extends CProjectTreeNode<Object> {
    private static final long serialVersionUID = 7710391862165745578L;
    private static final ImageIcon ICON_TRACES = new ImageIcon(CMain.class.getResource("data/projecttreeicons/debug_traces.png"));
    private final IViewContainer m_viewContainer;
    private final ITraceManagerListener m_listener = new InternalTraceListener();

    public CTracesNode(final JTree tree, final IViewContainer container) {
        super(tree, new CAbstractLazyComponent(){

            @Override
            protected CAbstractNodeComponent createComponent() {
                return new CTracesNodeComponent(tree, container);
            }
        }, new CRootNodeMenuBuilder(tree));
        Preconditions.checkNotNull(container, "IE02006: Container argument can not be null");
        this.m_viewContainer = container;
        container.getTraceProvider().addListener(this.m_listener);
    }

    @Override
    protected void createChildren() {
    }

    @Override
    public void dispose() {
        super.dispose();
        this.m_viewContainer.getTraceProvider().removeListener(this.m_listener);
    }

    @Override
    public void doubleClicked() {
    }

    @Override
    public Icon getIcon() {
        return ICON_TRACES;
    }

    @Override
    public String toString() {
        return String.format("Debug Traces (%d)", this.m_viewContainer.getTraceProvider().getNumberOfTraceLists());
    }

    private class InternalTraceListener
    implements ITraceManagerListener {
        private InternalTraceListener() {
        }

        @Override
        public void addedTrace(TraceList trace2) {
            CTracesNode.this.getTreeModel().nodeChanged(CTracesNode.this);
        }

        @Override
        public void loaded() {
        }

        @Override
        public void removedTrace(TraceList trace2) {
            CTracesNode.this.getTreeModel().nodeChanged(CTracesNode.this);
        }
    }
}

