/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.TagContainer.Component;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CAbstractNodeComponent;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Tag.Component.CChildTagsTable;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.binnavi.Tagging.CTagManager;
import com.google.security.zynamics.binnavi.Tagging.ITagManagerListener;
import com.google.security.zynamics.zylib.types.trees.ITreeNode;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.TitledBorder;

public final class CTagContainerNodeComponent
extends CAbstractNodeComponent {
    private static final long serialVersionUID = -339329908645324706L;
    private final IDatabase m_database;
    private final ITreeNode<CTag> m_tagTreeNode;
    private final CChildTagsTable m_childrenTagTable;
    private final TitledBorder m_tableBorder;
    private final InternalTagManagerListener m_tagManagerListener = new InternalTagManagerListener();

    public CTagContainerNodeComponent(JTree projectTree, IDatabase database) {
        super(new BorderLayout());
        Preconditions.checkNotNull(projectTree, "IE02003: Project tree argument can not be null");
        Preconditions.checkNotNull(database, "IE02004: Database argument can not be null");
        this.m_database = database;
        this.m_tagTreeNode = database.getContent().getViewTagManager().getRootTag();
        this.m_childrenTagTable = new CChildTagsTable(projectTree, this.m_tagTreeNode, database);
        this.m_tableBorder = new TitledBorder(this.getBorderTitle());
        this.m_database.getContent().getViewTagManager().addListener(this.m_tagManagerListener);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(this.m_tableBorder);
        JScrollPane scrollPane = new JScrollPane(this.m_childrenTagTable);
        panel.add((Component)scrollPane, "Center");
        this.add((Component)panel, "Center");
    }

    private String getBorderTitle() {
        return String.format("%d %s", this.m_tagTreeNode.getChildren().size(), "Child Tags");
    }

    @Override
    public void dispose() {
        this.m_database.getContent().getViewTagManager().removeListener(this.m_tagManagerListener);
        this.m_childrenTagTable.dispose();
    }

    private class InternalTagManagerListener
    implements ITagManagerListener {
        private InternalTagManagerListener() {
        }

        @Override
        public void addedTag(CTagManager manager, ITreeNode<CTag> tag) {
            if (((CTag)CTagContainerNodeComponent.this.m_tagTreeNode.getObject()).getId() == tag.getParent().getObject().getId()) {
                CTagContainerNodeComponent.this.m_tableBorder.setTitle(CTagContainerNodeComponent.this.getBorderTitle());
                CTagContainerNodeComponent.this.updateUI();
            }
        }

        @Override
        public void deletedTag(CTagManager manager, ITreeNode<CTag> parent, ITreeNode<CTag> tag) {
        }

        @Override
        public void deletedTagSubtree(CTagManager manager, ITreeNode<CTag> parent, ITreeNode<CTag> tag) {
        }

        @Override
        public void insertedTag(CTagManager tagManager, ITreeNode<CTag> parent, ITreeNode<CTag> tag) {
        }
    }
}

