/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.ProjectContainer.Component;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Gui.Actions.CActionProxy;
import com.google.security.zynamics.binnavi.Gui.HotKeys;
import com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations.CDatabaseFunctions;
import com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations.CProjectFunctions;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CAbstractTreeTable;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CLoadedRenderer;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Project.CProjectNodeMenuBuilder;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.ProjectContainer.Component.CProjectsModel;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.ProjectContainer.Component.Help.CProjectsTableHelp;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Updaters.CEmptyUpdater;
import com.google.security.zynamics.binnavi.disassembly.CProject;
import com.google.security.zynamics.binnavi.disassembly.INaviProject;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JPopupMenu;
import javax.swing.JTree;

public final class CProjectsTable
extends CAbstractTreeTable<INaviProject> {
    private static final long serialVersionUID = 2268882856382188306L;
    private final IDatabase m_database;

    public CProjectsTable(JTree projectTree, IDatabase database) {
        super(projectTree, new CProjectsModel(database), new CProjectsTableHelp());
        this.m_database = Preconditions.checkNotNull(database, "IE02874: database argument can not be null");
        this.setDefaultRenderer(Object.class, new ProjectLoadedRenderer());
        InputMap windowImap = this.getInputMap(0);
        windowImap.put(HotKeys.LOAD_HK.getKeyStroke(), "LOAD");
        this.getActionMap().put("LOAD", CActionProxy.proxy(new LoadProjectAction()));
    }

    private static CProject[] getUnloadedProjects(INaviProject[] iNaviProjects) {
        ArrayList<INaviProject> unloadedProjects = new ArrayList<INaviProject>();
        for (INaviProject project : iNaviProjects) {
            if (project.isLoaded()) continue;
            unloadedProjects.add(project);
        }
        return unloadedProjects.toArray(new CProject[0]);
    }

    private INaviProject[] getProjects(int[] sortSelectedRows) {
        INaviProject[] projects = new CProject[sortSelectedRows.length];
        for (int i2 = 0; i2 < projects.length; ++i2) {
            projects[i2] = this.getTreeTableModel().getProjects().get(sortSelectedRows[i2]);
        }
        return projects;
    }

    private INaviProject[] getSelectedProjects(int sortedRow) {
        int[] sortSelectedRows = this.getSortSelectedRows();
        if (Ints.asList(sortSelectedRows).indexOf(sortedRow) != -1) {
            return this.getProjects(sortSelectedRows);
        }
        int viewRow = this.convertRowIndexToView(sortedRow);
        this.setRowSelectionInterval(viewRow, viewRow);
        return new INaviProject[]{this.getTreeTableModel().getProjects().get(sortedRow)};
    }

    @Override
    protected void deleteRows() {
        CDatabaseFunctions.deleteProjects(this.getParentWindow(), this.m_database, this.getProjects(this.getSortSelectedRows()), new CEmptyUpdater());
    }

    @Override
    protected JPopupMenu getPopupMenu(int x2, int y2, int row) {
        CProjectNodeMenuBuilder menu = new CProjectNodeMenuBuilder(this.getProjectTree(), null, this.m_database, this.getSelectedProjects(row), this);
        return menu.getPopupMenu();
    }

    @Override
    protected void handleDoubleClick(int row) {
    }

    @Override
    public CProjectsModel getTreeTableModel() {
        return (CProjectsModel)super.getTreeTableModel();
    }

    private class ProjectLoadedRenderer
    extends CLoadedRenderer {
        private static final long serialVersionUID = -4896137097642356066L;

        private ProjectLoadedRenderer() {
        }

        @Override
        public boolean isLoaded(int row) {
            return CProjectsTable.this.getProjects(new int[]{CProjectsTable.this.convertRowIndexToModel(row)})[0].isLoaded();
        }
    }

    private class LoadProjectAction
    extends AbstractAction {
        private static final long serialVersionUID = 5356344926300001300L;

        private LoadProjectAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            CProjectFunctions.openProjects(CProjectsTable.this.getProjectTree(), CProjectsTable.getUnloadedProjects(CProjectsTable.this.getProjects(CProjectsTable.this.getSortSelectedRows())));
        }
    }
}

