/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.ProjectContainer.Component;

import com.google.security.zynamics.binnavi.Database.CDatabaseListenerAdapter;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.CTablePanel;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.ProjectContainer.Component.CProjectsTable;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.ProjectContainer.Component.Help.CProjectFilterHelp;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.filters.CProjectFilterCreator;
import com.google.security.zynamics.binnavi.disassembly.INaviProject;
import javax.swing.JTree;

public final class CProjectContainerNodeComponent
extends CTablePanel<INaviProject> {
    private static final long serialVersionUID = -542952607254442699L;
    private final IDatabase m_database;
    private final InternalDatabaseListener m_listener;

    public CProjectContainerNodeComponent(JTree projectTree, IDatabase database) {
        super(new CProjectsTable(projectTree, database), new CProjectFilterCreator(), new CProjectFilterHelp());
        this.m_database = database;
        this.m_listener = new InternalDatabaseListener();
        this.m_database.addListener(this.m_listener);
        this.updateBorderText(this.getBorderText());
    }

    private String getBorderText() {
        return String.format("%d Projects in Database '%s'", this.m_database.getContent().getProjects().size(), this.m_database.getConfiguration().getDescription());
    }

    @Override
    protected void disposeInternal() {
        this.m_database.removeListener(this.m_listener);
    }

    private class InternalDatabaseListener
    extends CDatabaseListenerAdapter {
        private InternalDatabaseListener() {
        }

        @Override
        public void addedProject(IDatabase connection, INaviProject newProject) {
            CProjectContainerNodeComponent.this.updateBorderText(CProjectContainerNodeComponent.this.getBorderText());
        }

        @Override
        public void deletedProject(IDatabase database, INaviProject project) {
            CProjectContainerNodeComponent.this.updateBorderText(CProjectContainerNodeComponent.this.getBorderText());
        }
    }
}

