/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.ProjectContainer;

import com.google.common.collect.Lists;
import com.google.security.zynamics.binnavi.API.disassembly.Database;
import com.google.security.zynamics.binnavi.API.plugins.IProjectFolderMenuPlugin;
import com.google.security.zynamics.binnavi.API.plugins.PluginInterface;
import com.google.security.zynamics.binnavi.APIHelpers.ObjectFinders;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Gui.Actions.CActionProxy;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions.CCreateProjectAction;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CAbstractMenuBuilder;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CProjectTreeNode;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CProjectTreeNodeHelpers;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.ProjectContainer.CProjectContainerNode;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Updaters.CNodeSelectionUpdater;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;

public final class CProjectContainerNodeMenuBuilder
extends CAbstractMenuBuilder {
    private final IDatabase database;

    public CProjectContainerNodeMenuBuilder(JTree projectTree, IDatabase database) {
        super(projectTree);
        this.database = database;
    }

    private CProjectTreeNode<?> findNode() {
        return this.findProjectContainerNode(CProjectTreeNodeHelpers.findDatabaseNode(this.getProjectTree(), this.database));
    }

    private CProjectTreeNode<?> findProjectContainerNode(CProjectTreeNode<?> databaseNode) {
        ArrayList<CProjectTreeNode> nodes = Lists.newArrayList();
        nodes.add(databaseNode);
        while (!nodes.isEmpty()) {
            CProjectTreeNode current = (CProjectTreeNode)nodes.get(0);
            nodes.remove(0);
            if (current instanceof CProjectContainerNode) {
                return current;
            }
            Enumeration<TreeNode> e2 = current.children();
            while (e2.hasMoreElements()) {
                nodes.add((CProjectTreeNode)e2.nextElement());
            }
        }
        throw new IllegalStateException("IE01203: Project container node not found");
    }

    private Database getPluginDatabase() {
        return ObjectFinders.getObject(this.database, PluginInterface.instance().getDatabaseManager().getDatabases());
    }

    @Override
    protected void createMenu(JComponent menu) {
        menu.add(new JMenuItem(CActionProxy.proxy(new CCreateProjectAction(this.getParent(), this.database, new CNodeSelectionUpdater(this.getProjectTree(), this.findNode())))));
        ArrayList<IProjectFolderMenuPlugin> plugins = new ArrayList<IProjectFolderMenuPlugin>();
        for (IProjectFolderMenuPlugin plugin : PluginInterface.instance().getPluginRegistry()) {
            if (!(plugin instanceof IProjectFolderMenuPlugin)) continue;
            plugins.add(plugin);
        }
        if (!plugins.isEmpty()) {
            menu.add(new JSeparator());
            for (IProjectFolderMenuPlugin plugin : plugins) {
                try {
                    List<JComponent> menuItems = plugin.extendProjectFolderMenu(this.getPluginDatabase());
                    if (menuItems == null) continue;
                    for (JComponent menuItem : menuItems) {
                        menu.add(menuItem);
                    }
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                    String innerMessage = "E00089: Plugin caused an unexpected exception";
                    String innerDescription = CUtilityFunctions.createDescription(String.format("The plugin %s caused an unexpected exception.", plugin.getName()), new String[]{"The plugin contains a bug."}, new String[]{"The plugin probably behaves erroneously from this point on but it remains active"});
                    NaviErrorDialog.show(this.getParent(), "E00089: Plugin caused an unexpected exception", innerDescription, exception);
                }
            }
        }
    }

    @Override
    protected JMenu getMenu() {
        JMenu menu = new JMenu("Projects");
        menu.setMnemonic("HK_MENU_PROJECTS".charAt(0));
        return menu;
    }
}

