/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.ProjectContainer;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CMain;
import com.google.security.zynamics.binnavi.Database.CDatabaseListenerAdapter;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CAbstractLazyComponent;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CAbstractNodeComponent;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CProjectTreeNode;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Project.CProjectNode;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.ProjectContainer.CProjectContainerNodeMenuBuilder;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.ProjectContainer.Component.CProjectContainerNodeComponent;
import com.google.security.zynamics.binnavi.disassembly.CProjectContainer;
import com.google.security.zynamics.binnavi.disassembly.INaviProject;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;

public final class CProjectContainerNode
extends CProjectTreeNode<Object> {
    private static final long serialVersionUID = 6914349402634037384L;
    private static final ImageIcon ICON_PROJECTS_CONTAINER = new ImageIcon(CMain.class.getResource("data/projecttreeicons/modules_container4.png"));
    private final IDatabase m_database;
    private final InternalDatabaseListener m_listener;

    public CProjectContainerNode(final JTree projectTree, final IDatabase database) {
        super(projectTree, new CAbstractLazyComponent(){

            @Override
            protected CAbstractNodeComponent createComponent() {
                return new CProjectContainerNodeComponent(projectTree, database);
            }
        }, new CProjectContainerNodeMenuBuilder(projectTree, database));
        Preconditions.checkNotNull(database, "IE01988: Database can't be null");
        this.m_database = database;
        this.createChildren();
        this.m_listener = new InternalDatabaseListener();
        database.addListener(this.m_listener);
    }

    @Override
    protected void createChildren() {
        if (this.m_database.isLoaded()) {
            for (INaviProject project : this.m_database.getContent().getProjects()) {
                this.add(new CProjectNode(this.getProjectTree(), this, this.m_database, project, new CProjectContainer(this.m_database, project)));
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.m_database.removeListener(this.m_listener);
        this.deleteChildren();
    }

    @Override
    public void doubleClicked() {
    }

    @Override
    public Icon getIcon() {
        return ICON_PROJECTS_CONTAINER;
    }

    @Override
    public String toString() {
        if (this.m_database.isLoaded()) {
            String string2 = String.valueOf("Projects (");
            int n2 = this.m_database.getContent().getProjects().size();
            return new StringBuilder(12 + String.valueOf(string2).length()).append(string2).append(n2).append(")").toString();
        }
        return "";
    }

    private class InternalDatabaseListener
    extends CDatabaseListenerAdapter {
        private InternalDatabaseListener() {
        }

        @Override
        public void addedProject(IDatabase connection, INaviProject project) {
            CProjectContainerNode.this.add(new CProjectNode(CProjectContainerNode.this.getProjectTree(), CProjectContainerNode.this, CProjectContainerNode.this.m_database, project, new CProjectContainer(CProjectContainerNode.this.m_database, project)));
            CProjectContainerNode.this.getTreeModel().nodeStructureChanged(CProjectContainerNode.this);
        }

        @Override
        public void deletedProject(IDatabase database, INaviProject project) {
            for (int i2 = 0; i2 < CProjectContainerNode.this.getChildCount(); ++i2) {
                CProjectNode node = (CProjectNode)CProjectContainerNode.this.getChildAt(i2);
                if (node.getObject() != project) continue;
                node.dispose();
                CProjectContainerNode.this.remove(node);
                break;
            }
            CProjectContainerNode.this.getTreeModel().nodeStructureChanged(CProjectContainerNode.this);
        }
    }
}

