/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Project.Component;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Gui.Actions.CActionProxy;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.Default.CAddressSpacesTablePanel;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CAbstractNodeComponent;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Project.Component.CAddressSpacesTable;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Project.Component.Help.CCreationDateHelp;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Project.Component.Help.CDescriptionHelp;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Project.Component.Help.CModificationDateHelp;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Project.Component.Help.CNameHelp;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Project.Component.Help.CSaveHelp;
import com.google.security.zynamics.binnavi.Gui.Progress.CGlobalProgressManager;
import com.google.security.zynamics.binnavi.Gui.Progress.IProgressOperation;
import com.google.security.zynamics.binnavi.Gui.StandardEditPanel.CDefaultFieldDescription;
import com.google.security.zynamics.binnavi.Gui.StandardEditPanel.CStandardEditPanel;
import com.google.security.zynamics.binnavi.Gui.StandardEditPanel.IInputPanelListener;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.Help.CHelpButton;
import com.google.security.zynamics.binnavi.debug.debugger.DebuggerTemplate;
import com.google.security.zynamics.binnavi.debug.debugger.DebuggerTemplateManager;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebuggerTemplateManagerListener;
import com.google.security.zynamics.binnavi.disassembly.AddressSpaces.CAddressSpace;
import com.google.security.zynamics.binnavi.disassembly.CProject;
import com.google.security.zynamics.binnavi.disassembly.CProjectListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.INaviAddressSpace;
import com.google.security.zynamics.binnavi.disassembly.INaviProject;
import com.google.security.zynamics.binnavi.disassembly.views.IViewContainer;
import com.google.security.zynamics.zylib.gui.JCheckedListbox;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.CProgressPanel;
import com.google.security.zynamics.zylib.gui.SwingInvoker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public final class CProjectNodeComponent
extends CAbstractNodeComponent {
    private final IDatabase m_database;
    private final INaviProject m_project;
    private final TitledBorder m_titledBorder;
    private final CStandardEditPanel m_stdEditPanel;
    private final CAddressSpacesTable m_table;
    private final JPanel m_checkedListPanel;
    private JCheckedListbox<DebuggerTemplate> m_checkedList;
    private final InternalProjectListener m_projectListener = new InternalProjectListener();
    private final InternalDebuggerDescriptionManagerListener m_debuggerManagerListener = new InternalDebuggerDescriptionManagerListener();
    private final JButton m_saveButton = new CHelpButton(CActionProxy.proxy(new SaveAction()), new CSaveHelp());
    private final UpdateListener m_updateListener = new UpdateListener();

    public CProjectNodeComponent(JTree projectTree, IDatabase database, INaviProject project, IViewContainer container) {
        super(new BorderLayout());
        Preconditions.checkNotNull(projectTree, "IE01985: Project tree argument can not be null");
        this.m_project = Preconditions.checkNotNull(project, "IE01986: Project argument can't be null");
        this.m_database = Preconditions.checkNotNull(database, "IE01987: Database argument can't be null");
        CDefaultFieldDescription<String> nameInfo = new CDefaultFieldDescription<String>(project.getConfiguration().getName(), new CNameHelp());
        CDefaultFieldDescription<String> descriptionInfo = new CDefaultFieldDescription<String>(project.getConfiguration().getDescription(), new CDescriptionHelp());
        CDefaultFieldDescription<Date> creationInfo = new CDefaultFieldDescription<Date>(project.getConfiguration().getCreationDate(), new CCreationDateHelp());
        CDefaultFieldDescription<Date> modificationInfo = new CDefaultFieldDescription<Date>(project.getConfiguration().getModificationDate(), new CModificationDateHelp());
        this.m_stdEditPanel = new CStandardEditPanel("Project", nameInfo, descriptionInfo, creationInfo, modificationInfo);
        this.m_checkedListPanel = new JPanel(new BorderLayout());
        this.m_table = new CAddressSpacesTable(projectTree, database, this.m_project, container);
        this.m_titledBorder = new TitledBorder(this.getBorderText());
        this.createGui();
        this.m_database.getContent().getDebuggerTemplateManager().addListener(this.m_debuggerManagerListener);
        project.addListener(this.m_projectListener);
        this.m_checkedList.addListSelectionListener(this.m_updateListener);
        this.m_stdEditPanel.addInputListener(this.m_updateListener);
        this.updateSaveButton();
    }

    private void createGui() {
        JPanel topPanel = new JPanel(new BorderLayout());
        JPanel innerTopPanel = new JPanel(new BorderLayout());
        innerTopPanel.add(this.m_stdEditPanel);
        topPanel.add(innerTopPanel);
        JPanel debuggerChooserPanel = new JPanel(new BorderLayout());
        debuggerChooserPanel.setBorder(new TitledBorder("Project Debuggers"));
        this.m_checkedList = new JCheckedListbox(new Vector(), false);
        this.updateCheckedListPanel();
        JScrollPane debuggerScrollPane = new JScrollPane(this.m_checkedList);
        this.m_checkedListPanel.add(debuggerScrollPane);
        debuggerChooserPanel.add((Component)this.m_checkedListPanel, "Center");
        debuggerChooserPanel.setMinimumSize(new Dimension(0, 128));
        debuggerChooserPanel.setPreferredSize(new Dimension(0, 128));
        innerTopPanel.add((Component)debuggerChooserPanel, "South");
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2));
        buttonPanel.setBorder(new EmptyBorder(0, 0, 5, 2));
        buttonPanel.add(new JPanel());
        buttonPanel.add(this.m_saveButton);
        topPanel.add((Component)buttonPanel, "South");
        CAddressSpacesTablePanel bottomPanel = new CAddressSpacesTablePanel(this.m_table);
        JScrollPane scrollPane = new JScrollPane(this.m_table);
        bottomPanel.setBorder(this.m_titledBorder);
        this.setBorder(new EmptyBorder(0, 0, 0, 1));
        bottomPanel.add(scrollPane);
        JSplitPane splitPane = new JSplitPane(0, true, topPanel, bottomPanel);
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerLocation(splitPane.getMinimumDividerLocation());
        splitPane.setResizeWeight(0.5);
        this.add(splitPane);
    }

    private String getBorderText() {
        return String.format("%d Address Spaces in Project '%s'", this.m_project.getAddressSpaceCount(), this.m_project.getConfiguration().getName());
    }

    private Vector<DebuggerTemplate> getDebuggerVector() {
        Vector<DebuggerTemplate> debuggers = new Vector<DebuggerTemplate>();
        for (DebuggerTemplate debugger : this.m_database.getContent().getDebuggerTemplateManager()) {
            debuggers.add(debugger);
        }
        return debuggers;
    }

    private Set<DebuggerTemplate> getSelectedDebuggers() {
        HashSet<DebuggerTemplate> selectedTemplates = new HashSet<DebuggerTemplate>();
        ListModel model = this.m_checkedList.getModel();
        for (int i2 = 0; i2 < model.getSize(); ++i2) {
            DebuggerTemplate debugger = (DebuggerTemplate)model.getElementAt(i2);
            if (!this.m_checkedList.isChecked(i2)) continue;
            selectedTemplates.add(debugger);
        }
        return selectedTemplates;
    }

    private void save() {
        new Thread(){

            @Override
            public void run() {
                CProjectSaveProgressOperation progressOperation = new CProjectSaveProgressOperation();
                progressOperation.getProgressPanel().setText("Saving project configuration: Saving Name");
                CProjectNodeComponent.this.saveName();
                progressOperation.getProgressPanel().next();
                progressOperation.getProgressPanel().setText("Saving project configuration: Saving Description");
                CProjectNodeComponent.this.saveDescription();
                progressOperation.getProgressPanel().next();
                progressOperation.getProgressPanel().setText("Saving project configuration: Saving Debuggers");
                CProjectNodeComponent.this.saveDebuggers();
                progressOperation.getProgressPanel().next();
                progressOperation.stop();
                CProjectNodeComponent.this.updateSaveButton();
            }
        }.start();
    }

    private void saveDebuggers() {
        try {
            ListModel model = this.m_checkedList.getModel();
            List<DebuggerTemplate> oldDebuggers = this.m_project.getConfiguration().getDebuggers();
            for (int i2 = 0; i2 < model.getSize(); ++i2) {
                DebuggerTemplate debugger = (DebuggerTemplate)model.getElementAt(i2);
                if (this.m_checkedList.isChecked(i2) && !oldDebuggers.contains(debugger)) {
                    this.m_project.getConfiguration().addDebugger(debugger);
                    continue;
                }
                if (this.m_checkedList.isChecked(i2) || !oldDebuggers.contains(debugger)) continue;
                this.m_project.getConfiguration().removeDebugger((DebuggerTemplate)model.getElementAt(i2));
            }
        }
        catch (CouldntSaveDataException e2) {
            CUtilityFunctions.logException(e2);
            String innerMessage = "E00173: Could not save project debuggers";
            String innerDescription = CUtilityFunctions.createDescription(String.format("The new debuggers of the project '%s' could not be saved.", this.m_project.getConfiguration().getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The project keeps its old debuggers."});
            NaviErrorDialog.show(SwingUtilities.getWindowAncestor(this), "E00173: Could not save project debuggers", innerDescription, e2);
        }
    }

    private void saveDescription() {
        try {
            this.m_project.getConfiguration().setDescription(this.m_stdEditPanel.getDescription());
        }
        catch (CouldntSaveDataException e2) {
            CUtilityFunctions.logException(e2);
            String innerMessage = "E00172: Could not save project description";
            String innerDescription = CUtilityFunctions.createDescription(String.format("The new description of the project '%s' could not be saved.", this.m_project.getConfiguration().getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The project keeps its old description."});
            NaviErrorDialog.show(SwingUtilities.getWindowAncestor(this), "E00172: Could not save project description", innerDescription, e2);
        }
    }

    private void saveName() {
        try {
            this.m_project.getConfiguration().setName(this.m_stdEditPanel.getNameString());
        }
        catch (CouldntSaveDataException e2) {
            CUtilityFunctions.logException(e2);
            String innerMessage = "E00171: Could not save project name";
            String innerDescription = CUtilityFunctions.createDescription(String.format("The new name of the project '%s' could not be saved.", this.m_project.getConfiguration().getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The project keeps its old name."});
            NaviErrorDialog.show(SwingUtilities.getWindowAncestor(this), "E00171: Could not save project name", innerDescription, e2);
        }
    }

    private void updateCheckedListPanel() {
        this.m_checkedList.removeListSelectionListener(this.m_updateListener);
        this.m_checkedListPanel.removeAll();
        this.m_checkedList = new JCheckedListbox<DebuggerTemplate>(this.getDebuggerVector(), false);
        this.m_checkedList.addListSelectionListener(this.m_updateListener);
        JScrollPane debuggerScrollPane = new JScrollPane(this.m_checkedList);
        this.m_checkedListPanel.add(debuggerScrollPane);
        List<DebuggerTemplate> debuggers = this.m_project.getConfiguration().getDebuggers();
        ListModel model = this.m_checkedList.getModel();
        for (int i2 = 0; i2 < model.getSize(); ++i2) {
            DebuggerTemplate debuggerId = (DebuggerTemplate)model.getElementAt(i2);
            this.m_checkedList.setChecked(i2, debuggers.contains(debuggerId));
        }
        this.m_checkedList.updateUI();
        this.updateUI();
    }

    private void updateSaveButton() {
        this.m_saveButton.setEnabled(!this.m_stdEditPanel.getNameString().equals(this.m_project.getConfiguration().getName()) || !this.m_stdEditPanel.getDescription().equals(this.m_project.getConfiguration().getDescription()) || !this.getSelectedDebuggers().equals(new HashSet<DebuggerTemplate>(this.m_project.getConfiguration().getDebuggers())));
    }

    @Override
    public void dispose() {
        this.m_project.removeListener(this.m_projectListener);
        this.m_database.getContent().getDebuggerTemplateManager().removeListener(this.m_debuggerManagerListener);
        this.m_table.dispose();
    }

    private class UpdateListener
    implements IInputPanelListener,
    ListSelectionListener {
        private UpdateListener() {
        }

        @Override
        public void changedInput() {
            CProjectNodeComponent.this.updateSaveButton();
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            CProjectNodeComponent.this.updateSaveButton();
        }
    }

    private class SaveAction
    extends AbstractAction {
        private SaveAction() {
            super("Save");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            CProjectNodeComponent.this.save();
        }
    }

    private class InternalProjectListener
    extends CProjectListenerAdapter {
        private InternalProjectListener() {
        }

        @Override
        public void addedAddressSpace(INaviProject project, CAddressSpace space) {
            CProjectNodeComponent.this.m_titledBorder.setTitle(CProjectNodeComponent.this.getBorderText());
            CProjectNodeComponent.this.updateUI();
        }

        @Override
        public void changedDescription(INaviProject project, final String description) {
            new SwingInvoker(){

                @Override
                protected void operation() {
                    CProjectNodeComponent.this.m_stdEditPanel.setDescription(description);
                }
            }.invokeLater();
        }

        @Override
        public void changedModificationDate(INaviProject project, final Date date) {
            new SwingInvoker(){

                @Override
                protected void operation() {
                    CProjectNodeComponent.this.m_stdEditPanel.setModificationDate(date);
                }
            }.invokeLater();
        }

        @Override
        public void changedName(INaviProject project, final String name) {
            new SwingInvoker(){

                @Override
                protected void operation() {
                    CProjectNodeComponent.this.m_stdEditPanel.setNameString(name);
                    CProjectNodeComponent.this.m_titledBorder.setTitle(CProjectNodeComponent.this.getBorderText());
                    CProjectNodeComponent.this.updateUI();
                }
            }.invokeLater();
        }

        @Override
        public void loadedProject(CProject project) {
            CProjectNodeComponent.this.m_titledBorder.setTitle(CProjectNodeComponent.this.getBorderText());
            CProjectNodeComponent.this.updateCheckedListPanel();
            CProjectNodeComponent.this.updateUI();
        }

        @Override
        public void removedAddressSpace(INaviProject project, INaviAddressSpace space) {
            CProjectNodeComponent.this.m_titledBorder.setTitle(CProjectNodeComponent.this.getBorderText());
            CProjectNodeComponent.this.updateUI();
        }
    }

    private class InternalDebuggerDescriptionManagerListener
    implements IDebuggerTemplateManagerListener {
        private InternalDebuggerDescriptionManagerListener() {
        }

        @Override
        public void addedDebugger(DebuggerTemplateManager manager, DebuggerTemplate debugger) {
            CProjectNodeComponent.this.updateCheckedListPanel();
        }

        @Override
        public void removedDebugger(DebuggerTemplateManager manager, DebuggerTemplate debugger) {
            CProjectNodeComponent.this.updateCheckedListPanel();
        }
    }

    private static class CProjectSaveProgressOperation
    implements IProgressOperation {
        private final CProgressPanel m_progressPanel = new CProgressPanel("", false, true);

        public CProjectSaveProgressOperation() {
            this.m_progressPanel.setMaximum(3);
            this.m_progressPanel.start();
            CGlobalProgressManager.instance().add(this);
        }

        @Override
        public String getDescription() {
            return "Saving project configuration";
        }

        @Override
        public CProgressPanel getProgressPanel() {
            return this.m_progressPanel;
        }

        public void stop() {
            this.m_progressPanel.stop();
            CGlobalProgressManager.instance().remove(this);
        }
    }
}

