/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Project.Component;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Gui.Actions.CActionProxy;
import com.google.security.zynamics.binnavi.Gui.HotKeys;
import com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations.CAddressSpaceFunctions;
import com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations.CProjectFunctions;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.AddressSpace.CAddressSpaceNodeMenuBuilder;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CAbstractTreeTable;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CLoadedRenderer;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Project.Component.CAddressSpacesModel;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Project.Component.Help.CAddressSpacesTableHelp;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Updaters.CEmptyUpdater;
import com.google.security.zynamics.binnavi.disassembly.AddressSpaces.CAddressSpace;
import com.google.security.zynamics.binnavi.disassembly.INaviAddressSpace;
import com.google.security.zynamics.binnavi.disassembly.INaviProject;
import com.google.security.zynamics.binnavi.disassembly.views.IViewContainer;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JPopupMenu;
import javax.swing.JTree;

public final class CAddressSpacesTable
extends CAbstractTreeTable<INaviAddressSpace> {
    private static final long serialVersionUID = -2366271508529117739L;
    private final IDatabase m_database;
    private final INaviProject m_project;
    private final IViewContainer m_container;

    public CAddressSpacesTable(JTree projectTree, IDatabase database, INaviProject project, IViewContainer container) {
        super(projectTree, new CAddressSpacesModel(project), new CAddressSpacesTableHelp());
        this.m_database = Preconditions.checkNotNull(database, "IE02871: database argument can not be null");
        this.m_project = Preconditions.checkNotNull(project, "IE02872: project argument can not be null");
        this.m_container = Preconditions.checkNotNull(container, "IE02873: container argument can not be null");
        this.setDefaultRenderer(Object.class, new AddressSpaceLoadedRenderer());
        InputMap windowImap = this.getInputMap(0);
        windowImap.put(HotKeys.LOAD_HK.getKeyStroke(), "LOAD");
        this.getActionMap().put("LOAD", CActionProxy.proxy(new LoadAddressSpaceAction()));
    }

    private INaviAddressSpace[] getAddressSpaces(int[] sortSelectedRows) {
        INaviAddressSpace[] addressSpaces = new INaviAddressSpace[sortSelectedRows.length];
        for (int i2 = 0; i2 < addressSpaces.length; ++i2) {
            addressSpaces[i2] = this.getTreeTableModel().getAddressSpaces().get(sortSelectedRows[i2]);
        }
        return addressSpaces;
    }

    private INaviAddressSpace[] getSelectedAddressSpaces(int sortedRow) {
        int[] sortSelectedRows = this.getSortSelectedRows();
        if (Ints.asList(sortSelectedRows).indexOf(sortedRow) != -1) {
            return this.getAddressSpaces(sortSelectedRows);
        }
        int viewRow = this.convertRowIndexToView(sortedRow);
        this.setRowSelectionInterval(viewRow, viewRow);
        return new INaviAddressSpace[]{this.getTreeTableModel().getAddressSpaces().get(sortedRow)};
    }

    private CAddressSpace[] getUnloadedAddressSpaces(INaviAddressSpace[] addressSpaces) {
        ArrayList<INaviAddressSpace> unloadedAddressSpaces = new ArrayList<INaviAddressSpace>();
        for (INaviAddressSpace module : addressSpaces) {
            if (module.isLoaded()) continue;
            unloadedAddressSpaces.add(module);
        }
        return unloadedAddressSpaces.toArray(new CAddressSpace[0]);
    }

    @Override
    protected void deleteRows() {
        CProjectFunctions.removeAddressSpace(this.getParentWindow(), this.m_project, this.getAddressSpaces(this.getSortSelectedRows()), new CEmptyUpdater());
    }

    @Override
    protected JPopupMenu getPopupMenu(int x2, int y2, int row) {
        CAddressSpaceNodeMenuBuilder menu = new CAddressSpaceNodeMenuBuilder(this.getProjectTree(), null, this, this.m_database, this.m_project, this.getSelectedAddressSpaces(row), this.m_container);
        return menu.getPopupMenu();
    }

    @Override
    protected void handleDoubleClick(int row) {
    }

    @Override
    public CAddressSpacesModel getTreeTableModel() {
        return (CAddressSpacesModel)super.getTreeTableModel();
    }

    private class LoadAddressSpaceAction
    extends AbstractAction {
        private static final long serialVersionUID = -8036270322086134717L;

        private LoadAddressSpaceAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            CAddressSpaceFunctions.loadAddressSpaces(CAddressSpacesTable.this.getProjectTree(), CAddressSpacesTable.this.getUnloadedAddressSpaces(CAddressSpacesTable.this.getAddressSpaces(CAddressSpacesTable.this.getSortSelectedRows())));
        }
    }

    private class AddressSpaceLoadedRenderer
    extends CLoadedRenderer {
        private static final long serialVersionUID = -7964915698433160450L;

        private AddressSpaceLoadedRenderer() {
        }

        @Override
        public boolean isLoaded(int row) {
            return CAddressSpacesTable.this.getAddressSpaces(new int[]{CAddressSpacesTable.this.convertRowIndexToModel(row)})[0].isLoaded();
        }
    }
}

