/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Project;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.API.disassembly.Database;
import com.google.security.zynamics.binnavi.API.disassembly.DatabaseManager;
import com.google.security.zynamics.binnavi.API.disassembly.Project;
import com.google.security.zynamics.binnavi.API.plugins.IProjectMenuPlugin;
import com.google.security.zynamics.binnavi.API.plugins.PluginInterface;
import com.google.security.zynamics.binnavi.APIHelpers.ObjectFinders;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Gui.Actions.CActionProxy;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions.CAddAddressSpaceAction;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions.CDeleteProjectAction;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions.CLoadProjectAction;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions.CResolveAllFunctionsSingleProjectAction;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions.CSearchAction;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions.CSearchTableAction;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CAbstractMenuBuilder;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CProjectTreeNode;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CProjectTreeNodeHelpers;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Project.CProjectNode;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.ProjectContainer.CProjectContainerNode;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Updaters.CEmptyNodeSelectionUpdater;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Updaters.CEmptyUpdater;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Updaters.CNodeSelectionUpdater;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Updaters.CParentSelectionUpdater;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Updaters.INodeSelectionUpdater;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Updaters.ITreeUpdater;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.api2.IPluginInterface;
import com.google.security.zynamics.binnavi.api2.plugins.IPlugin;
import com.google.security.zynamics.binnavi.disassembly.CProject;
import com.google.security.zynamics.binnavi.disassembly.CProjectContainer;
import com.google.security.zynamics.binnavi.disassembly.CProjectListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.INaviProject;
import com.google.security.zynamics.binnavi.disassembly.views.IViewContainer;
import com.google.security.zynamics.zylib.gui.tables.CopySelectionAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public final class CProjectNodeMenuBuilder
extends CAbstractMenuBuilder {
    private final DefaultMutableTreeNode m_parentNode;
    private final IDatabase m_database;
    private final INaviProject[] m_projects;
    private final JTable m_table;
    private Action m_addAddressSpaceAction;
    private final Action m_searchViewAction;
    private final Action m_forwardAction;
    private final InternalProjectListener m_listener = new InternalProjectListener();
    private final Action m_loadProjectAction;
    private IViewContainer m_container;

    public CProjectNodeMenuBuilder(JTree projectTree, DefaultMutableTreeNode parentNode, IDatabase database, INaviProject[] projects, JTable table) {
        super(projectTree);
        this.m_database = Preconditions.checkNotNull(database, "IE01982: Database argument can't be null");
        Preconditions.checkNotNull(projects, "IE01983: Project argument can't be null");
        this.m_parentNode = parentNode;
        this.m_projects = (INaviProject[])projects.clone();
        this.m_table = table;
        this.m_loadProjectAction = CActionProxy.proxy(new CLoadProjectAction(projectTree, projects));
        if (projects.length == 1) {
            INaviProject singleProject = projects[0];
            if (this.m_table == null) {
                singleProject.addListener(this.m_listener);
            }
            this.m_container = new CProjectContainer(database, singleProject);
            this.m_searchViewAction = CActionProxy.proxy(new CSearchAction(projectTree, this.m_container));
            this.m_forwardAction = CActionProxy.proxy(new CResolveAllFunctionsSingleProjectAction(projectTree, this.m_database, this.m_projects[0]));
            this.updateActions(singleProject);
        } else {
            this.m_addAddressSpaceAction = null;
            this.m_searchViewAction = null;
            this.m_forwardAction = null;
        }
    }

    private void addPluginMenus(JComponent menu) {
        ArrayList<IProjectMenuPlugin> plugins = new ArrayList<IProjectMenuPlugin>();
        for (IPlugin<IPluginInterface> plugin : PluginInterface.instance().getPluginRegistry()) {
            if (!(plugin instanceof IProjectMenuPlugin)) continue;
            plugins.add((IProjectMenuPlugin)plugin);
        }
        if (!plugins.isEmpty()) {
            boolean addedSeparator = false;
            for (IProjectMenuPlugin plugin : plugins) {
                try {
                    List<JComponent> menuItems = plugin.extendProjectMenu(this.getPluginProjects());
                    if (menuItems == null) continue;
                    for (JComponent menuItem : menuItems) {
                        if (!addedSeparator) {
                            menu.add(new JSeparator());
                            addedSeparator = true;
                        }
                        menu.add(menuItem);
                    }
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                    String innerMessage = "E00088: Plugin caused an unexpected exception";
                    String innerDescription = CUtilityFunctions.createDescription(String.format("The plugin %s caused an unexpected exception.", plugin.getName()), new String[]{"The plugin contains a bug."}, new String[]{"The plugin probably behaves erroneously from this point on but it remains active"});
                    NaviErrorDialog.show(this.getParent(), "E00088: Plugin caused an unexpected exception", innerDescription, exception);
                }
            }
        }
    }

    private boolean canOpen() {
        for (INaviProject project : this.m_projects) {
            if (!project.isLoaded()) continue;
            return false;
        }
        return true;
    }

    private CProjectTreeNode<?> findNode() {
        return this.findProjectNode(CProjectTreeNodeHelpers.findDatabaseNode(this.getProjectTree(), this.m_database), this.m_projects[0]);
    }

    private CProjectTreeNode<?> findProjectNode(CProjectTreeNode<?> databaseNode, INaviProject project) {
        ArrayList<CProjectTreeNode> nodes = new ArrayList<CProjectTreeNode>();
        nodes.add(databaseNode);
        while (!nodes.isEmpty()) {
            CProjectTreeNode current = (CProjectTreeNode)nodes.get(0);
            nodes.remove(0);
            if (current instanceof CProjectNode && ((CProjectNode)current).getObject() == project) {
                return current;
            }
            Enumeration<TreeNode> e2 = current.children();
            while (e2.hasMoreElements()) {
                CProjectTreeNode element = (CProjectTreeNode)e2.nextElement();
                if (!(element instanceof CProjectContainerNode) && !(element instanceof CProjectNode)) continue;
                nodes.add(element);
            }
        }
        throw new IllegalStateException("IE01202: Project node not found");
    }

    private ITreeUpdater getParentUpdater() {
        return this.m_parentNode == null ? new CEmptyUpdater() : new CParentSelectionUpdater(this.getProjectTree(), this.m_parentNode);
    }

    private List<Project> getPluginProjects() {
        DatabaseManager manager = PluginInterface.instance().getDatabaseManager();
        for (Database database : manager) {
            if (database.getNative() != this.m_database) continue;
            List<Project> allProjects = database.getProjects();
            ArrayList<Project> menuProjects = new ArrayList<Project>();
            for (INaviProject project : this.m_projects) {
                menuProjects.add(ObjectFinders.getObject(project, allProjects));
            }
            return menuProjects;
        }
        throw new IllegalStateException("IE01168: Unknown database");
    }

    private INodeSelectionUpdater getSelectionUpdater() {
        return this.m_table == null ? new CNodeSelectionUpdater(this.getProjectTree(), this.findNode()) : new CEmptyNodeSelectionUpdater();
    }

    private void updateActions(INaviProject project) {
        this.m_loadProjectAction.setEnabled(!project.isLoaded());
        if (this.m_addAddressSpaceAction != null) {
            this.m_addAddressSpaceAction.setEnabled(project.isLoaded());
        }
        this.m_searchViewAction.setEnabled(project.isLoaded());
        this.m_forwardAction.setEnabled(project.isLoaded());
    }

    @Override
    protected void createMenu(JComponent menu) {
        boolean isSingleSelection;
        if (this.m_projects.length == 1 && this.m_addAddressSpaceAction == null) {
            INaviProject singleProject = this.m_projects[0];
            this.m_addAddressSpaceAction = CActionProxy.proxy(new CAddAddressSpaceAction(this.getProjectTree(), singleProject, this.getSelectionUpdater()));
            this.updateActions(singleProject);
        }
        boolean bl2 = isSingleSelection = this.m_projects.length == 1;
        if (this.canOpen()) {
            menu.add(new JMenuItem(this.m_loadProjectAction));
            menu.add(new JSeparator());
        }
        if (isSingleSelection) {
            menu.add(new JMenuItem(this.m_searchViewAction));
            menu.add(new JSeparator());
            menu.add(new JMenuItem(this.m_addAddressSpaceAction));
            menu.add(new JSeparator());
            menu.add(new JMenuItem(this.m_forwardAction));
            menu.add(new JSeparator());
        }
        menu.add(new JMenuItem(CActionProxy.proxy(new CDeleteProjectAction(this.getParent(), this.m_database, this.m_projects, this.getParentUpdater()))));
        if (this.m_table != null) {
            menu.add(new JSeparator());
            menu.add(new JMenuItem(CActionProxy.proxy(new CSearchTableAction(this.getParent(), this.m_table))));
            menu.add(new JMenuItem(CActionProxy.proxy(new CopySelectionAction(this.m_table))));
        }
        this.addPluginMenus(menu);
    }

    @Override
    protected JMenu getMenu() {
        JMenu menu = new JMenu("Project");
        menu.setMnemonic("HK_MENU_PROJECT".charAt(0));
        return menu;
    }

    @Override
    public void dispose() {
        if (this.m_projects.length == 1) {
            this.m_projects[0].removeListener(this.m_listener);
            this.m_container.dispose();
        }
    }

    private class InternalProjectListener
    extends CProjectListenerAdapter {
        private InternalProjectListener() {
        }

        @Override
        public void loadedProject(CProject project) {
            CProjectNodeMenuBuilder.this.updateActions(project);
        }
    }
}

