/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Project;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CMain;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Gui.Actions.CActionProxy;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions.CLoadProjectAction;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.AddressSpace.CAddressSpaceNode;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CAbstractLazyComponent;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CAbstractNodeComponent;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CProjectTreeNode;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Project.CProjectNodeMenuBuilder;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Project.Component.CProjectNodeComponent;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Traces.CTracesNode;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Views.Project.CProjectViewsContainerNode;
import com.google.security.zynamics.binnavi.disassembly.AddressSpaces.CAddressSpace;
import com.google.security.zynamics.binnavi.disassembly.CProject;
import com.google.security.zynamics.binnavi.disassembly.CProjectContainer;
import com.google.security.zynamics.binnavi.disassembly.CProjectListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.INaviAddressSpace;
import com.google.security.zynamics.binnavi.disassembly.INaviProject;
import com.google.security.zynamics.zylib.gui.SwingInvoker;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

public final class CProjectNode
extends CProjectTreeNode<INaviProject> {
    private static final long serialVersionUID = -7833552492435605478L;
    private static final ImageIcon ICON_PROJECTS_CONTAINER = new ImageIcon(CMain.class.getResource("data/projecttreeicons/project3.png"));
    private static final ImageIcon ICON_PROJECTS_CONTAINER_GRAY = new ImageIcon(CMain.class.getResource("data/projecttreeicons/project3_gray.png"));
    private final IDatabase m_database;
    private final INaviProject m_project;
    private final InternalProjectListener m_listener;
    private final CProjectContainer m_container;

    public CProjectNode(final JTree projectTree, DefaultMutableTreeNode parentNode, final IDatabase database, final INaviProject project, final CProjectContainer contextContainer) {
        super(projectTree, new CAbstractLazyComponent(){

            @Override
            protected CAbstractNodeComponent createComponent() {
                return new CProjectNodeComponent(projectTree, database, project, contextContainer);
            }
        }, new CProjectNodeMenuBuilder(projectTree, parentNode, database, new INaviProject[]{project}, null), project);
        Preconditions.checkNotNull(database, "IE01980: Database can't be null");
        Preconditions.checkNotNull(project, "IE01981: Project can't be null");
        this.m_project = project;
        this.m_database = database;
        this.m_container = contextContainer;
        this.createChildren();
        this.m_listener = new InternalProjectListener();
        this.m_project.addListener(this.m_listener);
    }

    @Override
    protected void createChildren() {
        if (this.m_project.isLoaded()) {
            for (INaviAddressSpace addressSpace : this.m_project.getContent().getAddressSpaces()) {
                this.add(new CAddressSpaceNode(this.getProjectTree(), this, this.m_database, this.m_project, addressSpace, this.m_container));
            }
            this.add(new CProjectViewsContainerNode(this.getProjectTree(), this.m_project, this.m_container));
            this.add(new CTracesNode(this.getProjectTree(), this.m_container));
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.m_container.dispose();
        this.m_project.removeListener(this.m_listener);
        this.deleteChildren();
    }

    @Override
    public void doubleClicked() {
        if (!this.m_project.isLoaded()) {
            Action action = CActionProxy.proxy(new CLoadProjectAction(this.getProjectTree(), new INaviProject[]{this.m_project}));
            action.actionPerformed(new ActionEvent(this, 0, ""));
        }
    }

    @Override
    public CProjectNodeComponent getComponent() {
        return (CProjectNodeComponent)super.getComponent();
    }

    @Override
    public Icon getIcon() {
        return this.m_project.isLoaded() ? ICON_PROJECTS_CONTAINER : ICON_PROJECTS_CONTAINER_GRAY;
    }

    @Override
    public String toString() {
        String string2 = this.m_project.getConfiguration().getName();
        int n2 = this.m_project.getAddressSpaceCount();
        return new StringBuilder(14 + String.valueOf(string2).length()).append(string2).append(" (").append(n2).append(")").toString();
    }

    private class InternalProjectListener
    extends CProjectListenerAdapter {
        private InternalProjectListener() {
        }

        @Override
        public void addedAddressSpace(final INaviProject project, final CAddressSpace space) {
            new SwingInvoker(){

                @Override
                protected void operation() {
                    CProjectNode.this.insert(new CAddressSpaceNode(CProjectNode.this.getProjectTree(), CProjectNode.this, CProjectNode.this.m_database, project, space, CProjectNode.this.m_container), CProjectNode.this.getChildCount() - 2);
                    CProjectNode.this.getTreeModel().nodeStructureChanged(CProjectNode.this);
                }
            }.invokeAndWait();
        }

        @Override
        public void changedName(INaviProject project, String name) {
            CProjectNode.this.getTreeModel().nodeChanged(CProjectNode.this);
        }

        @Override
        public void loadedProject(CProject project) {
            new SwingInvoker(){

                @Override
                protected void operation() {
                    CProjectNode.this.createChildren();
                    CProjectNode.this.getTreeModel().nodeStructureChanged(CProjectNode.this);
                }
            }.invokeAndWait();
        }

        @Override
        public void removedAddressSpace(INaviProject project, final INaviAddressSpace addressSpace) {
            new SwingInvoker(){

                @Override
                protected void operation() {
                    for (int i2 = 0; i2 < CProjectNode.this.getChildCount(); ++i2) {
                        CAddressSpaceNode node;
                        if (!(CProjectNode.this.getChildAt(i2) instanceof CAddressSpaceNode) || (node = (CAddressSpaceNode)CProjectNode.this.getChildAt(i2)).getObject() != addressSpace) continue;
                        node.dispose();
                        CProjectNode.this.remove(node);
                        break;
                    }
                    CProjectNode.this.getTreeModel().nodeStructureChanged(CProjectNode.this);
                }
            }.invokeAndWait();
        }
    }
}

