/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.ModuleContainer.Component;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CMain;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.CDatabaseListenerAdapter;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.IFilter;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CAbstractTreeTableModel;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.Modules.CModuleListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.algorithms.CStaredItemFunctions;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public final class CModulesModel
extends CAbstractTreeTableModel<INaviModule> {
    private static final ImageIcon ICON_MODULE = new ImageIcon(CMain.class.getResource("data/projecttreeicons/project_module.png"));
    private static final ImageIcon ICON_MODULE_GRAY = new ImageIcon(CMain.class.getResource("data/projecttreeicons/project_module_gray.png"));
    private static final ImageIcon ICON_MODULE_BROKEN = new ImageIcon(CMain.class.getResource("data/projecttreeicons/project_module_broken.png"));
    private static final ImageIcon ICON_MODULE_UNCONVERTED = new ImageIcon(CMain.class.getResource("data/projecttreeicons/project_module_light_gray.png"));
    private static final long serialVersionUID = -3257027186612001802L;
    private static final int STATE = 0;
    private static final int NAME_COLUMN = 1;
    private static final int DESCRIPTION_COLUMN = 2;
    private static final int VIEWS_COLUMN = 3;
    private static final int CREATION_DATE_COLUMN = 4;
    private static final int MODIFICATION_DATE_COLUMN = 5;
    private final String[] COLUMNS = new String[]{"State", "Name", "Description", "Views", "Creation Date", "Modification Date"};
    private final IDatabase m_database;
    private final InternalDatabaseListener m_databaseListener = new InternalDatabaseListener();
    private final InternalModuleListener m_moduleListener = new InternalModuleListener();
    private List<INaviModule> m_cachedValues = null;

    public CModulesModel(IDatabase database) {
        Preconditions.checkNotNull(database, "IE01214: Database can't be null");
        this.m_database = database;
        this.m_database.addListener(this.m_databaseListener);
        if (this.m_database.isLoaded()) {
            for (INaviModule module : this.m_database.getContent().getModules()) {
                module.addListener(this.m_moduleListener);
            }
        }
    }

    private Icon getIcon(INaviModule module) {
        if (module.getConfiguration().getRawModule().isComplete() && module.isInitialized()) {
            return module.isLoaded() ? ICON_MODULE : ICON_MODULE_GRAY;
        }
        if (module.getConfiguration().getRawModule().isComplete() && !module.isInitialized()) {
            return ICON_MODULE_UNCONVERTED;
        }
        return ICON_MODULE_BROKEN;
    }

    @Override
    public void delete() {
        this.m_database.removeListener(this.m_databaseListener);
        if (this.m_database.isLoaded()) {
            for (INaviModule module : this.m_database.getContent().getModules()) {
                module.removeListener(this.m_moduleListener);
            }
        }
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 1: {
                return String.class;
            }
            case 0: {
                return ImageIcon.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return Integer.class;
            }
            case 4: {
                return Date.class;
            }
            case 5: {
                return Date.class;
            }
        }
        throw new IllegalArgumentException(String.format("Unexpected column index retrieved while determining column classes: %d", columnIndex));
    }

    @Override
    public int getColumnCount() {
        return this.COLUMNS.length;
    }

    @Override
    public String getColumnName(int index) {
        return this.COLUMNS[index];
    }

    public List<INaviModule> getModules() {
        List<INaviModule> localCachedValues = this.m_cachedValues;
        if (localCachedValues == null) {
            IFilter<INaviModule> filter = this.getFilter();
            localCachedValues = this.m_database.isConnected() ? (filter == null ? this.m_database.getContent().getModules() : filter.get(this.m_database.getContent().getModules())) : new ArrayList<INaviModule>();
        }
        CStaredItemFunctions.sort(localCachedValues);
        this.m_cachedValues = localCachedValues;
        return new ArrayList<INaviModule>(localCachedValues);
    }

    @Override
    public int getRowCount() {
        return this.getModules().size();
    }

    @Override
    public List<Pair<Integer, Comparator<?>>> getSorters() {
        return new ArrayList();
    }

    @Override
    public Object getValueAt(int row, int col) {
        INaviModule module = this.getModules().get(row);
        switch (col) {
            case 1: {
                return module.getConfiguration().getName();
            }
            case 0: {
                return this.getIcon(module);
            }
            case 2: {
                return module.getConfiguration().getDescription();
            }
            case 3: {
                return module.isLoaded() ? module.getContent().getViewContainer().getViews().size() : module.getCustomViewCount() + module.getFunctionCount() + 1;
            }
            case 4: {
                return module.getConfiguration().getCreationDate();
            }
            case 5: {
                return module.getConfiguration().getModificationDate();
            }
        }
        throw new IllegalStateException("IE01166: Invalid column");
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 1 || col == 2;
    }

    @Override
    public void setFilter(IFilter<INaviModule> filter) {
        this.m_cachedValues = null;
        super.setFilter(filter);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col != 1 && col != 2) {
            throw new IllegalStateException("IE01167: Column can not be edited");
        }
        INaviModule module = this.getModules().get(row);
        if (col == 1) {
            try {
                module.getConfiguration().setName((String)value);
            }
            catch (CouldntSaveDataException e2) {
                CUtilityFunctions.logException(e2);
                String message2 = "E00167: Could not change the module name";
                String description = CUtilityFunctions.createDescription("The new module name could not be saved to the database.", new String[]{"There was a problem with the connection to the database while the module name was saved"}, new String[]{"The module name was not saved. Please try to find out what went wrong with the database connection and try to save the module name again."});
                NaviErrorDialog.show(null, "E00167: Could not change the module name", description, e2);
            }
        } else if (col == 2) {
            try {
                module.getConfiguration().setDescription((String)value);
            }
            catch (CouldntSaveDataException e3) {
                CUtilityFunctions.logException(e3);
                String message3 = "E00168: Could not change the module description";
                String description = CUtilityFunctions.createDescription("The new module description could not be saved to the database.", new String[]{"There was a problem with the connection to the database while the module description was saved"}, new String[]{"The module description was not saved. Please try to find out what went wrong with the database connection and try to save the module description again."});
                NaviErrorDialog.show(null, "E00168: Could not change the module description", description, e3);
            }
        }
    }

    private class InternalModuleListener
    extends CModuleListenerAdapter {
        private InternalModuleListener() {
        }

        @Override
        public void addedView(INaviModule container, INaviView view) {
            CModulesModel.this.m_cachedValues = null;
            CModulesModel.this.fireTableDataChanged();
        }

        @Override
        public void changedDescription(INaviModule module, String description) {
            CModulesModel.this.m_cachedValues = null;
            CModulesModel.this.fireTableDataChanged();
        }

        @Override
        public void changedName(INaviModule module, String name) {
            CModulesModel.this.m_cachedValues = null;
            CModulesModel.this.fireTableDataChanged();
        }

        @Override
        public void changedStarState(INaviModule module, boolean isStared) {
            CModulesModel.this.m_cachedValues = null;
            CModulesModel.this.fireTableDataChanged();
        }

        @Override
        public void loadedModule(INaviModule module) {
            CModulesModel.this.m_cachedValues = null;
            CModulesModel.this.fireTableDataChanged();
        }

        @Override
        public void initializedModule(INaviModule module) {
            CModulesModel.this.m_cachedValues = null;
            CModulesModel.this.fireTableDataChanged();
        }
    }

    private class InternalDatabaseListener
    extends CDatabaseListenerAdapter {
        private InternalDatabaseListener() {
        }

        @Override
        public void addedModule(IDatabase database, INaviModule module) {
            CModulesModel.this.m_cachedValues = null;
            module.addListener(CModulesModel.this.m_moduleListener);
            CModulesModel.this.fireTableDataChanged();
        }

        @Override
        public void deletedModule(IDatabase database, INaviModule module) {
            CModulesModel.this.m_cachedValues = null;
            module.removeListener(CModulesModel.this.m_moduleListener);
            CModulesModel.this.fireTableDataChanged();
        }
    }
}

