/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.ModuleContainer.Component;

import com.google.security.zynamics.binnavi.Database.CDatabaseListenerAdapter;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.CTablePanel;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.IFilterFieldListener;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.AddressSpace.Component.Help.CModuleFilterHelp;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.ModuleContainer.Component.CModuleFilterFieldMenu;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.ModuleContainer.Component.CModulesTable;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.filters.CModuleFilterCreator;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import java.awt.event.MouseEvent;
import javax.swing.JTree;

public final class CModuleContainerComponent
extends CTablePanel<INaviModule> {
    private static final long serialVersionUID = 8335750212998290254L;
    private final IDatabase m_database;
    private final InternalDatabaseListener m_listener = new InternalDatabaseListener();
    private final IFilterFieldListener m_filterFieldListener = new InternalFilterFieldListener();

    public CModuleContainerComponent(JTree projectTree, IDatabase database) {
        super(new CModulesTable(projectTree, database), new CModuleFilterCreator(), new CModuleFilterHelp());
        this.m_database = database;
        this.m_database.addListener(this.m_listener);
        this.addListener(this.m_filterFieldListener);
        this.updateBorderText(this.getBorderText());
    }

    private String getBorderText() {
        return String.format("%d Modules in Database '%s'", this.m_database.getContent().getModules().size(), this.m_database.getConfiguration().getDescription());
    }

    @Override
    protected void disposeInternal() {
        this.m_database.removeListener(this.m_listener);
        this.removeListener(this.m_filterFieldListener);
    }

    private class InternalFilterFieldListener
    implements IFilterFieldListener {
        private InternalFilterFieldListener() {
        }

        private void showPopupMenu(MouseEvent event) {
            CModuleFilterFieldMenu menu = new CModuleFilterFieldMenu(CModuleContainerComponent.this.getFilterField());
            menu.show(event.getComponent(), event.getX(), event.getY());
        }

        @Override
        public void mousePressed(MouseEvent event) {
            if (event.isPopupTrigger()) {
                this.showPopupMenu(event);
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            if (event.isPopupTrigger()) {
                this.showPopupMenu(event);
            }
        }
    }

    private class InternalDatabaseListener
    extends CDatabaseListenerAdapter {
        private InternalDatabaseListener() {
        }

        @Override
        public void addedModule(IDatabase database, INaviModule module) {
            CModuleContainerComponent.this.updateBorderText(CModuleContainerComponent.this.getBorderText());
        }

        @Override
        public void deletedModule(IDatabase database, INaviModule module) {
            CModuleContainerComponent.this.updateBorderText(CModuleContainerComponent.this.getBorderText());
        }
    }
}

