/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.ModuleContainer.Component;

import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Gui.DebuggerComboBox.CDebuggerComboBox;
import com.google.security.zynamics.binnavi.Gui.DebuggerComboBox.CDebuggerComboModel;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.CLabeledComponent;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.IDebuggerContainer;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.ModuleContainer.Component.Help.COriginalAddressHelp;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.ModuleContainer.Component.Help.CRelocatedAddressHelp;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.ModuleContainer.Component.IDebuggerChooserPanelListener;
import com.google.security.zynamics.binnavi.Gui.SaveFields.CSaveFormattedField;
import com.google.security.zynamics.binnavi.Help.CHelpSaveFormattedField;
import com.google.security.zynamics.binnavi.Help.IHelpInformation;
import com.google.security.zynamics.binnavi.debug.debugger.DebuggerTemplate;
import com.google.security.zynamics.binnavi.disassembly.AddressSpaces.CAddressSpaceConfigurationListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.AddressSpaces.CAddressSpaceContent;
import com.google.security.zynamics.binnavi.disassembly.AddressSpaces.CAddressSpaceListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.AddressSpaces.IAddressSpaceContentListener;
import com.google.security.zynamics.binnavi.disassembly.INaviAddressSpace;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.Modules.CModuleListenerAdapter;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.Convert;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.gui.CHexFormatter;
import com.google.security.zynamics.zylib.gui.SwingInvoker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.DefaultFormatterFactory;

public final class CDebuggerChooserPanel
extends JPanel {
    private static final long serialVersionUID = 6446549535947125186L;
    private final INaviAddressSpace m_addressSpace;
    private final INaviModule m_module;
    private final CSaveFormattedField m_fileBaseAddr = new CHelpSaveFormattedField(new DefaultFormatterFactory(new CHexFormatter(8)), (IHelpInformation)new COriginalAddressHelp());
    private final CSaveFormattedField m_imageBaseAddr = new CHelpSaveFormattedField(new DefaultFormatterFactory(new CHexFormatter(8)), (IHelpInformation)new CRelocatedAddressHelp());
    private final JLabel m_debuggerName = new JLabel();
    private final CDebuggerComboBox m_debuggerCombo;
    private final InternalAddressSpaceListener m_addressSpaceListener = new InternalAddressSpaceListener();
    private final InternalAddressSpaceConfigurationListener m_addressSpaceConfigurationListener = new InternalAddressSpaceConfigurationListener();
    private final InternalAddressSpaceContentListener m_addressSpaceContentListener = new InternalAddressSpaceContentListener();
    private final InternalModuleListener m_listener = new InternalModuleListener();
    private final ListenerProvider<IDebuggerChooserPanelListener> m_listeners = new ListenerProvider();

    public CDebuggerChooserPanel(INaviAddressSpace addressSpace, INaviModule module, IDebuggerContainer container) {
        super(new BorderLayout());
        Object debuggerNameLabel;
        this.m_addressSpace = addressSpace;
        this.m_module = module;
        JPanel debuggerChooserPanel = new JPanel(new GridLayout(3, 1, 5, 5));
        debuggerChooserPanel.setBorder(new EmptyBorder(0, 0, 5, 0));
        JPanel debuggerPanel = new JPanel(new BorderLayout());
        if (addressSpace == null) {
            debuggerNameLabel = new JLabel("Debugger:");
            ((JComponent)debuggerNameLabel).setPreferredSize(new Dimension(170, 25));
            this.m_debuggerCombo = new CDebuggerComboBox(new CDebuggerComboModel(container));
            this.m_debuggerCombo.setBorder(new EmptyBorder(0, 5, 0, 0));
            this.updateDebuggersComboBox();
            debuggerPanel.add((Component)debuggerNameLabel, "West");
            debuggerPanel.add((Component)this.m_debuggerCombo, "Center");
            this.m_imageBaseAddr.setText(module.getConfiguration().getImageBase().toHexString());
        } else {
            this.m_debuggerCombo = null;
            debuggerNameLabel = new JLabel("Name");
            ((JComponent)debuggerNameLabel).setPreferredSize(new Dimension(170, 25));
            this.m_debuggerName.setBorder(new EmptyBorder(0, 5, 0, 0));
            this.updateDebuggerLabel();
            debuggerPanel.add((Component)debuggerNameLabel, "West");
            debuggerPanel.add((Component)this.m_debuggerName, "Center");
            this.m_imageBaseAddr.setText(addressSpace.getContent().getImageBase(module).toHexString());
        }
        this.m_fileBaseAddr.setText(module.getConfiguration().getFileBase().toHexString());
        debuggerChooserPanel.add(debuggerPanel);
        debuggerChooserPanel.add((Component)new CLabeledComponent("Original Base Address:", new COriginalAddressHelp(), this.m_fileBaseAddr), "South");
        debuggerChooserPanel.add((Component)new CLabeledComponent("Relocated Base Address:", new CRelocatedAddressHelp(), this.m_imageBaseAddr), "South");
        debuggerNameLabel = addressSpace == null ? "Module" : "Address Space";
        this.setBorder(new TitledBorder(new StringBuilder(9 + String.valueOf(debuggerNameLabel).length()).append((String)debuggerNameLabel).append(" ").append("Debugger").toString()));
        this.add((Component)debuggerChooserPanel, "Center");
        UpdateListener updateListener = new UpdateListener();
        this.m_fileBaseAddr.getDocument().addDocumentListener(updateListener);
        this.m_imageBaseAddr.getDocument().addDocumentListener(updateListener);
        if (this.m_debuggerCombo != null) {
            this.m_debuggerCombo.addActionListener(updateListener);
        }
        this.m_module.addListener(this.m_listener);
        if (this.m_addressSpace != null) {
            this.m_addressSpace.addListener(this.m_addressSpaceListener);
            this.m_addressSpace.getConfiguration().addListener(this.m_addressSpaceConfigurationListener);
        }
    }

    private boolean isFileBaseModified() {
        String fileBaseText = this.getFileBase();
        boolean fileBaseChanged = "".equals(fileBaseText) || !new CAddress(Convert.hexStringToLong(fileBaseText)).equals(this.m_module.getConfiguration().getFileBase());
        return fileBaseChanged;
    }

    private boolean isImageBaseModified() {
        String imageBaseText = this.getImageBase();
        if ("".equals(imageBaseText)) {
            return true;
        }
        CAddress enteredAddress = new CAddress(Convert.hexStringToLong(imageBaseText));
        if (this.m_addressSpace == null) {
            return !enteredAddress.equals(this.m_module.getConfiguration().getImageBase());
        }
        return !enteredAddress.equals(this.m_addressSpace.getContent().getImageBase(this.m_module));
    }

    private void updateDebuggerLabel() {
        DebuggerTemplate debugger = this.m_addressSpace.getConfiguration().getDebuggerTemplate();
        this.m_debuggerName.setText(debugger == null ? "-" : debugger.getName());
    }

    private void updateDebuggersComboBox() {
        if (this.m_debuggerCombo != null) {
            this.m_debuggerCombo.setSelectedDebugger(this.m_module.getConfiguration().getDebuggerTemplate());
        }
    }

    private void updateSaveFields() {
        this.m_imageBaseAddr.setModified(this.isImageBaseModified());
        this.m_fileBaseAddr.setModified(this.isFileBaseModified());
        if (this.m_debuggerCombo != null) {
            this.m_debuggerCombo.setModified(this.getSelectedDebugger() != this.m_module.getConfiguration().getDebuggerTemplate());
        }
    }

    public void addListener(IDebuggerChooserPanelListener listener) {
        this.m_listeners.addListener(listener);
    }

    public void dispose() {
        if (this.m_addressSpace != null) {
            this.m_addressSpace.removeListener(this.m_addressSpaceListener);
            this.m_addressSpace.getConfiguration().removeListener(this.m_addressSpaceConfigurationListener);
        }
    }

    public String getFileBase() {
        return this.m_fileBaseAddr.getText();
    }

    public String getImageBase() {
        return this.m_imageBaseAddr.getText();
    }

    public DebuggerTemplate getSelectedDebugger() {
        return this.m_debuggerCombo == null ? null : this.m_debuggerCombo.getSelectedDebugger();
    }

    public void removeListener(IDebuggerChooserPanelListener listener) {
        this.m_listeners.removeListener(listener);
    }

    private class UpdateListener
    implements DocumentListener,
    ActionListener {
        private UpdateListener() {
        }

        private void notifyListeners() {
            for (IDebuggerChooserPanelListener listener : CDebuggerChooserPanel.this.m_listeners) {
                try {
                    listener.inputChanged();
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            CDebuggerChooserPanel.this.updateSaveFields();
            this.notifyListeners();
        }

        @Override
        public void changedUpdate(DocumentEvent event) {
            CDebuggerChooserPanel.this.updateSaveFields();
            this.notifyListeners();
        }

        @Override
        public void insertUpdate(DocumentEvent event) {
            CDebuggerChooserPanel.this.updateSaveFields();
            this.notifyListeners();
        }

        @Override
        public void removeUpdate(DocumentEvent event) {
            CDebuggerChooserPanel.this.updateSaveFields();
            this.notifyListeners();
        }
    }

    private class InternalModuleListener
    extends CModuleListenerAdapter {
        private InternalModuleListener() {
        }

        @Override
        public void changedDebuggerTemplate(INaviModule module, DebuggerTemplate template) {
            new SwingInvoker(){

                @Override
                protected void operation() {
                    CDebuggerChooserPanel.this.updateDebuggersComboBox();
                    CDebuggerChooserPanel.this.updateSaveFields();
                }
            }.invokeLater();
        }

        @Override
        public void changedFileBase(INaviModule module, final IAddress fileBase) {
            new SwingInvoker(){

                @Override
                protected void operation() {
                    CDebuggerChooserPanel.this.m_fileBaseAddr.setText(fileBase.toHexString());
                    CDebuggerChooserPanel.this.updateSaveFields();
                }
            }.invokeLater();
        }

        @Override
        public void changedImageBase(INaviModule module, final IAddress imageBase) {
            new SwingInvoker(){

                @Override
                protected void operation() {
                    CDebuggerChooserPanel.this.m_imageBaseAddr.setText(imageBase.toHexString());
                    CDebuggerChooserPanel.this.updateSaveFields();
                }
            }.invokeLater();
        }

        @Override
        public void loadedModule(INaviModule module) {
            new SwingInvoker(){

                @Override
                protected void operation() {
                    CDebuggerChooserPanel.this.updateDebuggersComboBox();
                }
            }.invokeLater();
        }
    }

    private class InternalAddressSpaceListener
    extends CAddressSpaceListenerAdapter {
        private InternalAddressSpaceListener() {
        }

        @Override
        public void closed(INaviAddressSpace addressSpace, CAddressSpaceContent content) {
            content.removeListener(CDebuggerChooserPanel.this.m_addressSpaceContentListener);
        }

        @Override
        public void loaded(INaviAddressSpace addressSpace) {
            addressSpace.getContent().addListener(CDebuggerChooserPanel.this.m_addressSpaceContentListener);
        }
    }

    private class InternalAddressSpaceContentListener
    implements IAddressSpaceContentListener {
        private InternalAddressSpaceContentListener() {
        }

        @Override
        public void addedModule(INaviAddressSpace addressSpace, INaviModule module) {
        }

        @Override
        public void changedImageBase(INaviAddressSpace addressSpace, INaviModule module, IAddress address) {
            if (module == CDebuggerChooserPanel.this.m_module) {
                CDebuggerChooserPanel.this.m_imageBaseAddr.setText(address.toHexString());
                CDebuggerChooserPanel.this.updateSaveFields();
            }
        }

        @Override
        public void removedModule(INaviAddressSpace addressSpace, INaviModule module) {
        }
    }

    private class InternalAddressSpaceConfigurationListener
    extends CAddressSpaceConfigurationListenerAdapter {
        private InternalAddressSpaceConfigurationListener() {
        }

        @Override
        public void changedDebugger(INaviAddressSpace addressSpace, DebuggerTemplate debugger) {
            CDebuggerChooserPanel.this.updateDebuggerLabel();
            CDebuggerChooserPanel.this.updateSaveFields();
        }
    }
}

