/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.ModuleContainer;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Gui.Actions.CActionProxy;
import com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations.CNodeExpander;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions.CActionSortModulesById;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions.CActionSortModulesByName;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions.CImportModuleAction;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions.CRefreshRawModulesAction;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions.CResolveAllFunctionsAction;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CAbstractMenuBuilder;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CProjectTreeNode;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.ModuleContainer.CModuleContainerNode;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;

public final class CModuleContainerNodeMenuBuilder
extends CAbstractMenuBuilder {
    private final IDatabase m_database;
    private CModuleContainerNode m_containerNode = null;

    public CModuleContainerNodeMenuBuilder(JTree projectTree, IDatabase database) {
        super(projectTree);
        Preconditions.checkNotNull(database, "IE01975: Database argument can't be null");
        this.m_database = database;
    }

    private CModuleContainerNode getModuleContainerNode(CProjectTreeNode<?> node) {
        for (int i2 = 0; i2 < node.getChildCount(); ++i2) {
            TreeNode child = node.getChildAt(i2);
            if (!(child instanceof CModuleContainerNode)) continue;
            return (CModuleContainerNode)child;
        }
        throw new IllegalStateException("IE00693: Could not find module container node");
    }

    @Override
    protected void createMenu(JComponent menu) {
        if (this.m_containerNode == null) {
            this.m_containerNode = this.getModuleContainerNode(CNodeExpander.findNode(this.getProjectTree(), this.m_database));
        }
        menu.add(new JMenuItem(CActionProxy.proxy(new CImportModuleAction(this.getParent(), this.m_database))));
        menu.add(new JMenuItem(CActionProxy.proxy(new CRefreshRawModulesAction(this.getParent(), this.m_database))));
        menu.add(new JMenuItem(CActionProxy.proxy(new CResolveAllFunctionsAction(menu, this.m_database))));
        menu.add(new JSeparator());
        JMenu sortMenu = new JMenu("Sort");
        JRadioButtonMenuItem idMenu = new JRadioButtonMenuItem(new CActionSortModulesById(this.m_containerNode));
        idMenu.setSelected(!this.m_containerNode.isSorted());
        sortMenu.add(idMenu);
        JRadioButtonMenuItem nameMenu = new JRadioButtonMenuItem(new CActionSortModulesByName(this.m_containerNode));
        nameMenu.setSelected(this.m_containerNode.isSorted());
        sortMenu.add(nameMenu);
        menu.add(sortMenu);
    }

    @Override
    protected JMenu getMenu() {
        JMenu menu = new JMenu("Module");
        menu.setMnemonic("HK_MENU_MODULE".charAt(0));
        return menu;
    }
}

