/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.ModuleContainer;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CMain;
import com.google.security.zynamics.binnavi.Database.CDatabaseListenerAdapter;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CAbstractLazyComponent;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CAbstractNodeComponent;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CProjectTreeNode;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Module.CModuleNode;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.ModuleContainer.CModuleContainerNodeMenuBuilder;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.ModuleContainer.Component.CModuleContainerComponent;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.Modules.CModuleContainer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;

public final class CModuleContainerNode
extends CProjectTreeNode<Object> {
    private static final ImageIcon ICON_MODULE_CONTAINER = new ImageIcon(CMain.class.getResource("data/projecttreeicons/modules_container3.png"));
    private final IDatabase m_database;
    private final InternalDatabaseListener m_listener;
    private boolean sortByName = false;

    public CModuleContainerNode(final JTree projectTree, final IDatabase database) {
        super(projectTree, new CAbstractLazyComponent(){

            @Override
            protected CAbstractNodeComponent createComponent() {
                return new CModuleContainerComponent(projectTree, database);
            }
        }, new CModuleContainerNodeMenuBuilder(projectTree, database));
        Preconditions.checkNotNull(database, "IE01979: Database can't be null");
        this.m_database = database;
        this.createChildren();
        this.m_listener = new InternalDatabaseListener();
        this.m_database.addListener(this.m_listener);
    }

    @Override
    protected void createChildren() {
        if (this.m_database.isLoaded()) {
            for (INaviModule module : this.m_database.getContent().getModules()) {
                this.add(new CModuleNode(this.getProjectTree(), this, this.m_database, module, new CModuleContainer(this.m_database, module)));
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.m_database.removeListener(this.m_listener);
        this.deleteChildren();
    }

    @Override
    public void doubleClicked() {
    }

    @Override
    public TreeNode getChildAt(int index) {
        ArrayList sortedChildren = new ArrayList(this.children);
        if (this.sortByName) {
            Collections.sort(sortedChildren, new Comparator<CModuleNode>(){

                @Override
                public int compare(CModuleNode lhs, CModuleNode rhs) {
                    return ((INaviModule)lhs.getObject()).getConfiguration().getName().compareTo(((INaviModule)rhs.getObject()).getConfiguration().getName());
                }
            });
        }
        return (TreeNode)sortedChildren.get(index);
    }

    @Override
    public Icon getIcon() {
        return ICON_MODULE_CONTAINER;
    }

    public boolean isSorted() {
        return this.sortByName;
    }

    public void setSorted(boolean sorted) {
        this.sortByName = sorted;
        this.getTreeModel().nodeStructureChanged(this);
    }

    @Override
    public String toString() {
        String string2 = String.valueOf("Modules (");
        int n2 = this.m_database.getContent().getModules().size();
        return new StringBuilder(12 + String.valueOf(string2).length()).append(string2).append(n2).append(")").toString();
    }

    private class InternalDatabaseListener
    extends CDatabaseListenerAdapter {
        private InternalDatabaseListener() {
        }

        @Override
        public void addedModule(IDatabase database, INaviModule module) {
            CModuleContainerNode.this.getTreeModel().insertNodeInto(new CModuleNode(CModuleContainerNode.this.getProjectTree(), CModuleContainerNode.this, database, module, new CModuleContainer(database, module)), CModuleContainerNode.this, CModuleContainerNode.this.getChildCount());
        }

        @Override
        public void deletedModule(IDatabase database, INaviModule module) {
            for (int i2 = 0; i2 < CModuleContainerNode.this.getChildCount(); ++i2) {
                CModuleNode node = (CModuleNode)CModuleContainerNode.this.getChildAt(i2);
                if (node.getObject() != module) continue;
                CModuleContainerNode.this.getTreeModel().removeNodeFromParent(node);
                node.dispose();
                break;
            }
        }
    }
}

